/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.Incentive;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.PackingConfiguration;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.ShippingConfiguration;

@Schema(description="A packing option contains a set of pack groups plus additional information about the packing option, such as any discounts or fees if it's selected.")
public class PackingOption {
    @SerializedName(value="discounts")
    private List<Incentive> discounts = new ArrayList<Incentive>();
    @SerializedName(value="expiration")
    private OffsetDateTime expiration = null;
    @SerializedName(value="fees")
    private List<Incentive> fees = new ArrayList<Incentive>();
    @SerializedName(value="packingGroups")
    private List<String> packingGroups = new ArrayList<String>();
    @SerializedName(value="packingOptionId")
    private String packingOptionId = null;
    @SerializedName(value="status")
    private String status = null;
    @SerializedName(value="supportedConfigurations")
    private List<PackingConfiguration> supportedConfigurations = new ArrayList<PackingConfiguration>();
    @SerializedName(value="supportedShippingConfigurations")
    private List<ShippingConfiguration> supportedShippingConfigurations = new ArrayList<ShippingConfiguration>();

    public PackingOption discounts(List<Incentive> discounts) {
        this.discounts = discounts;
        return this;
    }

    public PackingOption addDiscountsItem(Incentive discountsItem) {
        this.discounts.add(discountsItem);
        return this;
    }

    @Schema(required=true, description="Discount for the offered option.")
    public List<Incentive> getDiscounts() {
        return this.discounts;
    }

    public void setDiscounts(List<Incentive> discounts) {
        this.discounts = discounts;
    }

    public PackingOption expiration(OffsetDateTime expiration) {
        this.expiration = expiration;
        return this;
    }

    @Schema(description="The time at which this packing option is no longer valid. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) datetime format with pattern `yyyy-MM-ddTHH:mm:ss.sssZ`.")
    public OffsetDateTime getExpiration() {
        return this.expiration;
    }

    public void setExpiration(OffsetDateTime expiration) {
        this.expiration = expiration;
    }

    public PackingOption fees(List<Incentive> fees) {
        this.fees = fees;
        return this;
    }

    public PackingOption addFeesItem(Incentive feesItem) {
        this.fees.add(feesItem);
        return this;
    }

    @Schema(required=true, description="Fee for the offered option.")
    public List<Incentive> getFees() {
        return this.fees;
    }

    public void setFees(List<Incentive> fees) {
        this.fees = fees;
    }

    public PackingOption packingGroups(List<String> packingGroups) {
        this.packingGroups = packingGroups;
        return this;
    }

    public PackingOption addPackingGroupsItem(String packingGroupsItem) {
        this.packingGroups.add(packingGroupsItem);
        return this;
    }

    @Schema(required=true, description="Packing group IDs.")
    public List<String> getPackingGroups() {
        return this.packingGroups;
    }

    public void setPackingGroups(List<String> packingGroups) {
        this.packingGroups = packingGroups;
    }

    public PackingOption packingOptionId(String packingOptionId) {
        this.packingOptionId = packingOptionId;
        return this;
    }

    @Schema(required=true, description="Identifier of a packing option.")
    public String getPackingOptionId() {
        return this.packingOptionId;
    }

    public void setPackingOptionId(String packingOptionId) {
        this.packingOptionId = packingOptionId;
    }

    public PackingOption status(String status) {
        this.status = status;
        return this;
    }

    @Schema(required=true, description="The status of the packing option. Possible values: `OFFERED`, `ACCEPTED`, `EXPIRED`.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public PackingOption supportedConfigurations(List<PackingConfiguration> supportedConfigurations) {
        this.supportedConfigurations = supportedConfigurations;
        return this;
    }

    public PackingOption addSupportedConfigurationsItem(PackingConfiguration supportedConfigurationsItem) {
        this.supportedConfigurations.add(supportedConfigurationsItem);
        return this;
    }

    @Schema(required=true, description="A list of possible configurations for this option.")
    public List<PackingConfiguration> getSupportedConfigurations() {
        return this.supportedConfigurations;
    }

    public void setSupportedConfigurations(List<PackingConfiguration> supportedConfigurations) {
        this.supportedConfigurations = supportedConfigurations;
    }

    public PackingOption supportedShippingConfigurations(List<ShippingConfiguration> supportedShippingConfigurations) {
        this.supportedShippingConfigurations = supportedShippingConfigurations;
        return this;
    }

    public PackingOption addSupportedShippingConfigurationsItem(ShippingConfiguration supportedShippingConfigurationsItem) {
        this.supportedShippingConfigurations.add(supportedShippingConfigurationsItem);
        return this;
    }

    @Schema(required=true, description="**This field is deprecated**. Use the `shippingRequirements` property under `supportedConfigurations` instead. List of supported shipping modes.")
    public List<ShippingConfiguration> getSupportedShippingConfigurations() {
        return this.supportedShippingConfigurations;
    }

    public void setSupportedShippingConfigurations(List<ShippingConfiguration> supportedShippingConfigurations) {
        this.supportedShippingConfigurations = supportedShippingConfigurations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackingOption packingOption = (PackingOption)o;
        return Objects.equals(this.discounts, packingOption.discounts) && Objects.equals(this.expiration, packingOption.expiration) && Objects.equals(this.fees, packingOption.fees) && Objects.equals(this.packingGroups, packingOption.packingGroups) && Objects.equals(this.packingOptionId, packingOption.packingOptionId) && Objects.equals(this.status, packingOption.status) && Objects.equals(this.supportedConfigurations, packingOption.supportedConfigurations) && Objects.equals(this.supportedShippingConfigurations, packingOption.supportedShippingConfigurations);
    }

    public int hashCode() {
        return Objects.hash(this.discounts, this.expiration, this.fees, this.packingGroups, this.packingOptionId, this.status, this.supportedConfigurations, this.supportedShippingConfigurations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PackingOption {\n");
        sb.append("    discounts: ").append(this.toIndentedString(this.discounts)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    fees: ").append(this.toIndentedString(this.fees)).append("\n");
        sb.append("    packingGroups: ").append(this.toIndentedString(this.packingGroups)).append("\n");
        sb.append("    packingOptionId: ").append(this.toIndentedString(this.packingOptionId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    supportedConfigurations: ").append(this.toIndentedString(this.supportedConfigurations)).append("\n");
        sb.append("    supportedShippingConfigurations: ").append(this.toIndentedString(this.supportedShippingConfigurations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

