/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="A problem with additional properties persisted to an operation.")
public class OperationProblem {
    @SerializedName(value="code")
    private String code = null;
    @SerializedName(value="details")
    private String details = null;
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="severity")
    private String severity = null;

    public OperationProblem code(String code) {
        this.code = code;
        return this;
    }

    @Schema(required=true, description="An error code that identifies the type of error that occurred.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public OperationProblem details(String details) {
        this.details = details;
        return this;
    }

    @Schema(description="Additional details that can help the caller understand or fix the issue.")
    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public OperationProblem message(String message) {
        this.message = message;
        return this;
    }

    @Schema(required=true, description="A message that describes the error condition.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public OperationProblem severity(String severity) {
        this.severity = severity;
        return this;
    }

    @Schema(required=true, description="The severity of the problem. Possible values: `WARNING`, `ERROR`.")
    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationProblem operationProblem = (OperationProblem)o;
        return Objects.equals(this.code, operationProblem.code) && Objects.equals(this.details, operationProblem.details) && Objects.equals(this.message, operationProblem.message) && Objects.equals(this.severity, operationProblem.severity);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.details, this.message, this.severity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationProblem {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    severity: ").append(this.toIndentedString(this.severity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

