/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Contains input information to update Less-Than-Truckload (LTL) tracking information.")
public class LtlTrackingDetailInput {
    @SerializedName(value="billOfLadingNumber")
    private String billOfLadingNumber = null;
    @SerializedName(value="freightBillNumber")
    private List<String> freightBillNumber = new ArrayList<String>();

    public LtlTrackingDetailInput billOfLadingNumber(String billOfLadingNumber) {
        this.billOfLadingNumber = billOfLadingNumber;
        return this;
    }

    @Schema(description="The number of the carrier shipment acknowledgement document.")
    public String getBillOfLadingNumber() {
        return this.billOfLadingNumber;
    }

    public void setBillOfLadingNumber(String billOfLadingNumber) {
        this.billOfLadingNumber = billOfLadingNumber;
    }

    public LtlTrackingDetailInput freightBillNumber(List<String> freightBillNumber) {
        this.freightBillNumber = freightBillNumber;
        return this;
    }

    public LtlTrackingDetailInput addFreightBillNumberItem(String freightBillNumberItem) {
        this.freightBillNumber.add(freightBillNumberItem);
        return this;
    }

    @Schema(required=true, description="Number associated with the freight bill.")
    public List<String> getFreightBillNumber() {
        return this.freightBillNumber;
    }

    public void setFreightBillNumber(List<String> freightBillNumber) {
        this.freightBillNumber = freightBillNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LtlTrackingDetailInput ltlTrackingDetailInput = (LtlTrackingDetailInput)o;
        return Objects.equals(this.billOfLadingNumber, ltlTrackingDetailInput.billOfLadingNumber) && Objects.equals(this.freightBillNumber, ltlTrackingDetailInput.freightBillNumber);
    }

    public int hashCode() {
        return Objects.hash(this.billOfLadingNumber, this.freightBillNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LtlTrackingDetailInput {\n");
        sb.append("    billOfLadingNumber: ").append(this.toIndentedString(this.billOfLadingNumber)).append("\n");
        sb.append("    freightBillNumber: ").append(this.toIndentedString(this.freightBillNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

