/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Contains information related to Less-Than-Truckload (LTL) shipment tracking.")
public class LtlTrackingDetail {
    @SerializedName(value="billOfLadingNumber")
    private String billOfLadingNumber = null;
    @SerializedName(value="freightBillNumber")
    private List<String> freightBillNumber = null;

    public LtlTrackingDetail billOfLadingNumber(String billOfLadingNumber) {
        this.billOfLadingNumber = billOfLadingNumber;
        return this;
    }

    @Schema(description="The number of the carrier shipment acknowledgement document.")
    public String getBillOfLadingNumber() {
        return this.billOfLadingNumber;
    }

    public void setBillOfLadingNumber(String billOfLadingNumber) {
        this.billOfLadingNumber = billOfLadingNumber;
    }

    public LtlTrackingDetail freightBillNumber(List<String> freightBillNumber) {
        this.freightBillNumber = freightBillNumber;
        return this;
    }

    public LtlTrackingDetail addFreightBillNumberItem(String freightBillNumberItem) {
        if (this.freightBillNumber == null) {
            this.freightBillNumber = new ArrayList<String>();
        }
        this.freightBillNumber.add(freightBillNumberItem);
        return this;
    }

    @Schema(description="The number associated with the freight bill.")
    public List<String> getFreightBillNumber() {
        return this.freightBillNumber;
    }

    public void setFreightBillNumber(List<String> freightBillNumber) {
        this.freightBillNumber = freightBillNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LtlTrackingDetail ltlTrackingDetail = (LtlTrackingDetail)o;
        return Objects.equals(this.billOfLadingNumber, ltlTrackingDetail.billOfLadingNumber) && Objects.equals(this.freightBillNumber, ltlTrackingDetail.freightBillNumber);
    }

    public int hashCode() {
        return Objects.hash(this.billOfLadingNumber, this.freightBillNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LtlTrackingDetail {\n");
        sb.append("    billOfLadingNumber: ").append(this.toIndentedString(this.billOfLadingNumber)).append("\n");
        sb.append("    freightBillNumber: ").append(this.toIndentedString(this.freightBillNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

