/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.LabelOwner;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.PrepOwner;

@Schema(description="Defines an item's input parameters.")
public class ItemInput {
    @SerializedName(value="expiration")
    private String expiration = null;
    @SerializedName(value="labelOwner")
    private LabelOwner labelOwner = null;
    @SerializedName(value="manufacturingLotCode")
    private String manufacturingLotCode = null;
    @SerializedName(value="msku")
    private String msku = null;
    @SerializedName(value="prepOwner")
    private PrepOwner prepOwner = null;
    @SerializedName(value="quantity")
    private Integer quantity = null;

    public ItemInput expiration(String expiration) {
        this.expiration = expiration;
        return this;
    }

    @Schema(description="The expiration date of the MSKU. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) datetime format with pattern `YYYY-MM-DD`. Items with the same MSKU but different expiration dates cannot go into the same box.")
    public String getExpiration() {
        return this.expiration;
    }

    public void setExpiration(String expiration) {
        this.expiration = expiration;
    }

    public ItemInput labelOwner(LabelOwner labelOwner) {
        this.labelOwner = labelOwner;
        return this;
    }

    @Schema(required=true, description="")
    public LabelOwner getLabelOwner() {
        return this.labelOwner;
    }

    public void setLabelOwner(LabelOwner labelOwner) {
        this.labelOwner = labelOwner;
    }

    public ItemInput manufacturingLotCode(String manufacturingLotCode) {
        this.manufacturingLotCode = manufacturingLotCode;
        return this;
    }

    @Schema(description="The manufacturing lot code.")
    public String getManufacturingLotCode() {
        return this.manufacturingLotCode;
    }

    public void setManufacturingLotCode(String manufacturingLotCode) {
        this.manufacturingLotCode = manufacturingLotCode;
    }

    public ItemInput msku(String msku) {
        this.msku = msku;
        return this;
    }

    @Schema(required=true, description="The merchant SKU, a merchant-supplied identifier of a specific SKU.")
    public String getMsku() {
        return this.msku;
    }

    public void setMsku(String msku) {
        this.msku = msku;
    }

    public ItemInput prepOwner(PrepOwner prepOwner) {
        this.prepOwner = prepOwner;
        return this;
    }

    @Schema(required=true, description="")
    public PrepOwner getPrepOwner() {
        return this.prepOwner;
    }

    public void setPrepOwner(PrepOwner prepOwner) {
        this.prepOwner = prepOwner;
    }

    public ItemInput quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Schema(required=true, description="The number of units of the specified MSKU that will be shipped.")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemInput itemInput = (ItemInput)o;
        return Objects.equals(this.expiration, itemInput.expiration) && Objects.equals((Object)this.labelOwner, (Object)itemInput.labelOwner) && Objects.equals(this.manufacturingLotCode, itemInput.manufacturingLotCode) && Objects.equals(this.msku, itemInput.msku) && Objects.equals((Object)this.prepOwner, (Object)itemInput.prepOwner) && Objects.equals(this.quantity, itemInput.quantity);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.expiration, this.labelOwner, this.manufacturingLotCode, this.msku, this.prepOwner, this.quantity});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemInput {\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    labelOwner: ").append(this.toIndentedString((Object)this.labelOwner)).append("\n");
        sb.append("    manufacturingLotCode: ").append(this.toIndentedString(this.manufacturingLotCode)).append("\n");
        sb.append("    msku: ").append(this.toIndentedString(this.msku)).append("\n");
        sb.append("    prepOwner: ").append(this.toIndentedString((Object)this.prepOwner)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

