/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.PrepInstruction;

@Schema(description="Information associated with a single SKU in the seller's catalog.")
public class Item {
    @SerializedName(value="asin")
    private String asin = null;
    @SerializedName(value="expiration")
    private String expiration = null;
    @SerializedName(value="fnsku")
    private String fnsku = null;
    @SerializedName(value="labelOwner")
    private String labelOwner = null;
    @SerializedName(value="manufacturingLotCode")
    private String manufacturingLotCode = null;
    @SerializedName(value="msku")
    private String msku = null;
    @SerializedName(value="prepInstructions")
    private List<PrepInstruction> prepInstructions = new ArrayList<PrepInstruction>();
    @SerializedName(value="quantity")
    private Integer quantity = null;

    public Item asin(String asin) {
        this.asin = asin;
        return this;
    }

    @Schema(required=true, description="The Amazon Standard Identification Number (ASIN) of the item.")
    public String getAsin() {
        return this.asin;
    }

    public void setAsin(String asin) {
        this.asin = asin;
    }

    public Item expiration(String expiration) {
        this.expiration = expiration;
        return this;
    }

    @Schema(description="The expiration date of the MSKU. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) datetime format with pattern`YYYY-MM-DD`. The same MSKU with different expiration dates cannot go into the same box.")
    public String getExpiration() {
        return this.expiration;
    }

    public void setExpiration(String expiration) {
        this.expiration = expiration;
    }

    public Item fnsku(String fnsku) {
        this.fnsku = fnsku;
        return this;
    }

    @Schema(required=true, description="A unique identifier assigned by Amazon to products stored in and fulfilled from an Amazon fulfillment center.")
    public String getFnsku() {
        return this.fnsku;
    }

    public void setFnsku(String fnsku) {
        this.fnsku = fnsku;
    }

    public Item labelOwner(String labelOwner) {
        this.labelOwner = labelOwner;
        return this;
    }

    @Schema(required=true, description="Specifies who will label the items. Options include `AMAZON`, `SELLER`, and `NONE`.")
    public String getLabelOwner() {
        return this.labelOwner;
    }

    public void setLabelOwner(String labelOwner) {
        this.labelOwner = labelOwner;
    }

    public Item manufacturingLotCode(String manufacturingLotCode) {
        this.manufacturingLotCode = manufacturingLotCode;
        return this;
    }

    @Schema(description="The manufacturing lot code.")
    public String getManufacturingLotCode() {
        return this.manufacturingLotCode;
    }

    public void setManufacturingLotCode(String manufacturingLotCode) {
        this.manufacturingLotCode = manufacturingLotCode;
    }

    public Item msku(String msku) {
        this.msku = msku;
        return this;
    }

    @Schema(required=true, description="The merchant-defined SKU ID.")
    public String getMsku() {
        return this.msku;
    }

    public void setMsku(String msku) {
        this.msku = msku;
    }

    public Item prepInstructions(List<PrepInstruction> prepInstructions) {
        this.prepInstructions = prepInstructions;
        return this;
    }

    public Item addPrepInstructionsItem(PrepInstruction prepInstructionsItem) {
        this.prepInstructions.add(prepInstructionsItem);
        return this;
    }

    @Schema(required=true, description="Special preparations that are required for an item.")
    public List<PrepInstruction> getPrepInstructions() {
        return this.prepInstructions;
    }

    public void setPrepInstructions(List<PrepInstruction> prepInstructions) {
        this.prepInstructions = prepInstructions;
    }

    public Item quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Schema(required=true, description="The number of the specified MSKU.")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Item item = (Item)o;
        return Objects.equals(this.asin, item.asin) && Objects.equals(this.expiration, item.expiration) && Objects.equals(this.fnsku, item.fnsku) && Objects.equals(this.labelOwner, item.labelOwner) && Objects.equals(this.manufacturingLotCode, item.manufacturingLotCode) && Objects.equals(this.msku, item.msku) && Objects.equals(this.prepInstructions, item.prepInstructions) && Objects.equals(this.quantity, item.quantity);
    }

    public int hashCode() {
        return Objects.hash(this.asin, this.expiration, this.fnsku, this.labelOwner, this.manufacturingLotCode, this.msku, this.prepInstructions, this.quantity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Item {\n");
        sb.append("    asin: ").append(this.toIndentedString(this.asin)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    fnsku: ").append(this.toIndentedString(this.fnsku)).append("\n");
        sb.append("    labelOwner: ").append(this.toIndentedString(this.labelOwner)).append("\n");
        sb.append("    manufacturingLotCode: ").append(this.toIndentedString(this.manufacturingLotCode)).append("\n");
        sb.append("    msku: ").append(this.toIndentedString(this.msku)).append("\n");
        sb.append("    prepInstructions: ").append(this.toIndentedString(this.prepInstructions)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

