/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@Schema(description="Resource to download the requested document.")
public class DocumentDownload {
    @SerializedName(value="downloadType")
    private String downloadType = null;
    @SerializedName(value="expiration")
    private OffsetDateTime expiration = null;
    @SerializedName(value="uri")
    private String uri = null;

    public DocumentDownload downloadType(String downloadType) {
        this.downloadType = downloadType;
        return this;
    }

    @Schema(required=true, description="The type of download. Possible values: `URL`.")
    public String getDownloadType() {
        return this.downloadType;
    }

    public void setDownloadType(String downloadType) {
        this.downloadType = downloadType;
    }

    public DocumentDownload expiration(OffsetDateTime expiration) {
        this.expiration = expiration;
        return this;
    }

    @Schema(description="The URI's expiration time. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) datetime format with pattern `yyyy-MM-ddTHH:mm:ss.sssZ`.")
    public OffsetDateTime getExpiration() {
        return this.expiration;
    }

    public void setExpiration(OffsetDateTime expiration) {
        this.expiration = expiration;
    }

    public DocumentDownload uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Schema(required=true, description="Uniform resource identifier to identify where the document is located.")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentDownload documentDownload = (DocumentDownload)o;
        return Objects.equals(this.downloadType, documentDownload.downloadType) && Objects.equals(this.expiration, documentDownload.expiration) && Objects.equals(this.uri, documentDownload.uri);
    }

    public int hashCode() {
        return Objects.hash(this.downloadType, this.expiration, this.uri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentDownload {\n");
        sb.append("    downloadType: ").append(this.toIndentedString(this.downloadType)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

