/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.AddressInput;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.ItemInput;

@Schema(description="The `createInboundPlan` request.")
public class CreateInboundPlanRequest {
    @SerializedName(value="destinationMarketplaces")
    private List<String> destinationMarketplaces = new ArrayList<String>();
    @SerializedName(value="items")
    private List<ItemInput> items = new ArrayList<ItemInput>();
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="sourceAddress")
    private AddressInput sourceAddress = null;

    public CreateInboundPlanRequest destinationMarketplaces(List<String> destinationMarketplaces) {
        this.destinationMarketplaces = destinationMarketplaces;
        return this;
    }

    public CreateInboundPlanRequest addDestinationMarketplacesItem(String destinationMarketplacesItem) {
        this.destinationMarketplaces.add(destinationMarketplacesItem);
        return this;
    }

    @Schema(required=true, description="Marketplaces where the items need to be shipped to. Currently only one marketplace can be selected in this request.")
    public List<String> getDestinationMarketplaces() {
        return this.destinationMarketplaces;
    }

    public void setDestinationMarketplaces(List<String> destinationMarketplaces) {
        this.destinationMarketplaces = destinationMarketplaces;
    }

    public CreateInboundPlanRequest items(List<ItemInput> items) {
        this.items = items;
        return this;
    }

    public CreateInboundPlanRequest addItemsItem(ItemInput itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @Schema(required=true, description="Items included in this plan.")
    public List<ItemInput> getItems() {
        return this.items;
    }

    public void setItems(List<ItemInput> items) {
        this.items = items;
    }

    public CreateInboundPlanRequest name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name for the Inbound Plan. If one isn't provided, a default name will be provided.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateInboundPlanRequest sourceAddress(AddressInput sourceAddress) {
        this.sourceAddress = sourceAddress;
        return this;
    }

    @Schema(required=true, description="")
    public AddressInput getSourceAddress() {
        return this.sourceAddress;
    }

    public void setSourceAddress(AddressInput sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateInboundPlanRequest createInboundPlanRequest = (CreateInboundPlanRequest)o;
        return Objects.equals(this.destinationMarketplaces, createInboundPlanRequest.destinationMarketplaces) && Objects.equals(this.items, createInboundPlanRequest.items) && Objects.equals(this.name, createInboundPlanRequest.name) && Objects.equals(this.sourceAddress, createInboundPlanRequest.sourceAddress);
    }

    public int hashCode() {
        return Objects.hash(this.destinationMarketplaces, this.items, this.name, this.sourceAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateInboundPlanRequest {\n");
        sb.append("    destinationMarketplaces: ").append(this.toIndentedString(this.destinationMarketplaces)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sourceAddress: ").append(this.toIndentedString(this.sourceAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

