/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.RequestedUpdates;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.TransportationOption;

@Schema(description="Preview of the changes that will be applied to the shipment.")
public class ContentUpdatePreview {
    @SerializedName(value="contentUpdatePreviewId")
    private String contentUpdatePreviewId = null;
    @SerializedName(value="expiration")
    private OffsetDateTime expiration = null;
    @SerializedName(value="requestedUpdates")
    private RequestedUpdates requestedUpdates = null;
    @SerializedName(value="transportationOption")
    private TransportationOption transportationOption = null;

    public ContentUpdatePreview contentUpdatePreviewId(String contentUpdatePreviewId) {
        this.contentUpdatePreviewId = contentUpdatePreviewId;
        return this;
    }

    @Schema(required=true, description="Identifier of a content update preview.")
    public String getContentUpdatePreviewId() {
        return this.contentUpdatePreviewId;
    }

    public void setContentUpdatePreviewId(String contentUpdatePreviewId) {
        this.contentUpdatePreviewId = contentUpdatePreviewId;
    }

    public ContentUpdatePreview expiration(OffsetDateTime expiration) {
        this.expiration = expiration;
        return this;
    }

    @Schema(required=true, description="The time at which the content update expires. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) datetime format with pattern `yyyy-MM-ddTHH:mm:ss.sssZ`.")
    public OffsetDateTime getExpiration() {
        return this.expiration;
    }

    public void setExpiration(OffsetDateTime expiration) {
        this.expiration = expiration;
    }

    public ContentUpdatePreview requestedUpdates(RequestedUpdates requestedUpdates) {
        this.requestedUpdates = requestedUpdates;
        return this;
    }

    @Schema(required=true, description="")
    public RequestedUpdates getRequestedUpdates() {
        return this.requestedUpdates;
    }

    public void setRequestedUpdates(RequestedUpdates requestedUpdates) {
        this.requestedUpdates = requestedUpdates;
    }

    public ContentUpdatePreview transportationOption(TransportationOption transportationOption) {
        this.transportationOption = transportationOption;
        return this;
    }

    @Schema(required=true, description="")
    public TransportationOption getTransportationOption() {
        return this.transportationOption;
    }

    public void setTransportationOption(TransportationOption transportationOption) {
        this.transportationOption = transportationOption;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentUpdatePreview contentUpdatePreview = (ContentUpdatePreview)o;
        return Objects.equals(this.contentUpdatePreviewId, contentUpdatePreview.contentUpdatePreviewId) && Objects.equals(this.expiration, contentUpdatePreview.expiration) && Objects.equals(this.requestedUpdates, contentUpdatePreview.requestedUpdates) && Objects.equals(this.transportationOption, contentUpdatePreview.transportationOption);
    }

    public int hashCode() {
        return Objects.hash(this.contentUpdatePreviewId, this.expiration, this.requestedUpdates, this.transportationOption);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContentUpdatePreview {\n");
        sb.append("    contentUpdatePreviewId: ").append(this.toIndentedString(this.contentUpdatePreviewId)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    requestedUpdates: ").append(this.toIndentedString(this.requestedUpdates)).append("\n");
        sb.append("    transportationOption: ").append(this.toIndentedString(this.transportationOption)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

