/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.BoxContentInformationSource;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.Dimensions;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.Item;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.Region;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.Weight;

@Schema(description="Contains information about a box that is used in the inbound plan. The box is a container that holds multiple items.")
public class Box {
    @SerializedName(value="boxId")
    private String boxId = null;
    @SerializedName(value="contentInformationSource")
    private BoxContentInformationSource contentInformationSource = null;
    @SerializedName(value="destinationRegion")
    private Region destinationRegion = null;
    @SerializedName(value="dimensions")
    private Dimensions dimensions = null;
    @SerializedName(value="externalContainerIdentifier")
    private String externalContainerIdentifier = null;
    @SerializedName(value="externalContainerIdentifierType")
    private String externalContainerIdentifierType = null;
    @SerializedName(value="items")
    private List<Item> items = null;
    @SerializedName(value="packageId")
    private String packageId = null;
    @SerializedName(value="quantity")
    private Integer quantity = null;
    @SerializedName(value="templateName")
    private String templateName = null;
    @SerializedName(value="weight")
    private Weight weight = null;

    public Box boxId(String boxId) {
        this.boxId = boxId;
        return this;
    }

    @Schema(description="The ID provided by Amazon that identifies a given box. This ID is comprised of the external shipment ID (which is generated after transportation has been confirmed) and the index of the box.")
    public String getBoxId() {
        return this.boxId;
    }

    public void setBoxId(String boxId) {
        this.boxId = boxId;
    }

    public Box contentInformationSource(BoxContentInformationSource contentInformationSource) {
        this.contentInformationSource = contentInformationSource;
        return this;
    }

    @Schema(description="")
    public BoxContentInformationSource getContentInformationSource() {
        return this.contentInformationSource;
    }

    public void setContentInformationSource(BoxContentInformationSource contentInformationSource) {
        this.contentInformationSource = contentInformationSource;
    }

    public Box destinationRegion(Region destinationRegion) {
        this.destinationRegion = destinationRegion;
        return this;
    }

    @Schema(description="")
    public Region getDestinationRegion() {
        return this.destinationRegion;
    }

    public void setDestinationRegion(Region destinationRegion) {
        this.destinationRegion = destinationRegion;
    }

    public Box dimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    @Schema(description="")
    public Dimensions getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
    }

    public Box externalContainerIdentifier(String externalContainerIdentifier) {
        this.externalContainerIdentifier = externalContainerIdentifier;
        return this;
    }

    @Schema(description="The external identifier for this container / box.")
    public String getExternalContainerIdentifier() {
        return this.externalContainerIdentifier;
    }

    public void setExternalContainerIdentifier(String externalContainerIdentifier) {
        this.externalContainerIdentifier = externalContainerIdentifier;
    }

    public Box externalContainerIdentifierType(String externalContainerIdentifierType) {
        this.externalContainerIdentifierType = externalContainerIdentifierType;
        return this;
    }

    @Schema(description="Type of the external identifier used. Can be: `AMAZON`, `SSCC`.")
    public String getExternalContainerIdentifierType() {
        return this.externalContainerIdentifierType;
    }

    public void setExternalContainerIdentifierType(String externalContainerIdentifierType) {
        this.externalContainerIdentifierType = externalContainerIdentifierType;
    }

    public Box items(List<Item> items) {
        this.items = items;
        return this;
    }

    public Box addItemsItem(Item itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<Item>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Schema(description="Items contained within the box.")
    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public Box packageId(String packageId) {
        this.packageId = packageId;
        return this;
    }

    @Schema(required=true, description="Primary key to uniquely identify a Package (Box or Pallet).")
    public String getPackageId() {
        return this.packageId;
    }

    public void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    public Box quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Schema(description="The number of containers where all other properties like weight or dimensions are identical.")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Box templateName(String templateName) {
        this.templateName = templateName;
        return this;
    }

    @Schema(description="Template name of the box.")
    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public Box weight(Weight weight) {
        this.weight = weight;
        return this;
    }

    @Schema(description="")
    public Weight getWeight() {
        return this.weight;
    }

    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Box box = (Box)o;
        return Objects.equals(this.boxId, box.boxId) && Objects.equals((Object)this.contentInformationSource, (Object)box.contentInformationSource) && Objects.equals(this.destinationRegion, box.destinationRegion) && Objects.equals(this.dimensions, box.dimensions) && Objects.equals(this.externalContainerIdentifier, box.externalContainerIdentifier) && Objects.equals(this.externalContainerIdentifierType, box.externalContainerIdentifierType) && Objects.equals(this.items, box.items) && Objects.equals(this.packageId, box.packageId) && Objects.equals(this.quantity, box.quantity) && Objects.equals(this.templateName, box.templateName) && Objects.equals(this.weight, box.weight);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.boxId, this.contentInformationSource, this.destinationRegion, this.dimensions, this.externalContainerIdentifier, this.externalContainerIdentifierType, this.items, this.packageId, this.quantity, this.templateName, this.weight});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Box {\n");
        sb.append("    boxId: ").append(this.toIndentedString(this.boxId)).append("\n");
        sb.append("    contentInformationSource: ").append(this.toIndentedString((Object)this.contentInformationSource)).append("\n");
        sb.append("    destinationRegion: ").append(this.toIndentedString(this.destinationRegion)).append("\n");
        sb.append("    dimensions: ").append(this.toIndentedString(this.dimensions)).append("\n");
        sb.append("    externalContainerIdentifier: ").append(this.toIndentedString(this.externalContainerIdentifier)).append("\n");
        sb.append("    externalContainerIdentifierType: ").append(this.toIndentedString(this.externalContainerIdentifierType)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    packageId: ").append(this.toIndentedString(this.packageId)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    templateName: ").append(this.toIndentedString(this.templateName)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

