/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Specific details to identify a place.")
public class Address {
    @SerializedName(value="Name")
    private String name = null;
    @SerializedName(value="AddressLine1")
    private String addressLine1 = null;
    @SerializedName(value="AddressLine2")
    private String addressLine2 = null;
    @SerializedName(value="DistrictOrCounty")
    private String districtOrCounty = null;
    @SerializedName(value="City")
    private String city = null;
    @SerializedName(value="StateOrProvinceCode")
    private String stateOrProvinceCode = null;
    @SerializedName(value="CountryCode")
    private String countryCode = null;
    @SerializedName(value="PostalCode")
    private String postalCode = null;

    public Address name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="Name of the individual or business.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Address addressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
        return this;
    }

    @Schema(required=true, description="The street address information.")
    public String getAddressLine1() {
        return this.addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public Address addressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
        return this;
    }

    @Schema(description="Additional street address information, if required.")
    public String getAddressLine2() {
        return this.addressLine2;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public Address districtOrCounty(String districtOrCounty) {
        this.districtOrCounty = districtOrCounty;
        return this;
    }

    @Schema(description="The district or county.")
    public String getDistrictOrCounty() {
        return this.districtOrCounty;
    }

    public void setDistrictOrCounty(String districtOrCounty) {
        this.districtOrCounty = districtOrCounty;
    }

    public Address city(String city) {
        this.city = city;
        return this;
    }

    @Schema(required=true, description="The city.")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Address stateOrProvinceCode(String stateOrProvinceCode) {
        this.stateOrProvinceCode = stateOrProvinceCode;
        return this;
    }

    @Schema(required=true, description="The state or province code.  If state or province codes are used in your marketplace, it is recommended that you include one with your request. This helps Amazon to select the most appropriate Amazon fulfillment center for your inbound shipment plan.")
    public String getStateOrProvinceCode() {
        return this.stateOrProvinceCode;
    }

    public void setStateOrProvinceCode(String stateOrProvinceCode) {
        this.stateOrProvinceCode = stateOrProvinceCode;
    }

    public Address countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Schema(required=true, description="The country code in two-character ISO 3166-1 alpha-2 format.")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public Address postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Schema(required=true, description="The postal code.  If postal codes are used in your marketplace, we recommended that you include one with your request. This helps Amazon select the most appropriate Amazon fulfillment center for the inbound shipment plan.")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return Objects.equals(this.name, address.name) && Objects.equals(this.addressLine1, address.addressLine1) && Objects.equals(this.addressLine2, address.addressLine2) && Objects.equals(this.districtOrCounty, address.districtOrCounty) && Objects.equals(this.city, address.city) && Objects.equals(this.stateOrProvinceCode, address.stateOrProvinceCode) && Objects.equals(this.countryCode, address.countryCode) && Objects.equals(this.postalCode, address.postalCode);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.addressLine1, this.addressLine2, this.districtOrCounty, this.city, this.stateOrProvinceCode, this.countryCode, this.postalCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Address {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    addressLine1: ").append(this.toIndentedString(this.addressLine1)).append("\n");
        sb.append("    addressLine2: ").append(this.toIndentedString(this.addressLine2)).append("\n");
        sb.append("    districtOrCounty: ").append(this.toIndentedString(this.districtOrCounty)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    stateOrProvinceCode: ").append(this.toIndentedString(this.stateOrProvinceCode)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

