/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v2024_06_19;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.finances.v2024_06_19.Breakdown;
import software.amazon.spapi.models.finances.v2024_06_19.Contexts;
import software.amazon.spapi.models.finances.v2024_06_19.Currency;
import software.amazon.spapi.models.finances.v2024_06_19.Items;
import software.amazon.spapi.models.finances.v2024_06_19.MarketplaceDetails;
import software.amazon.spapi.models.finances.v2024_06_19.RelatedIdentifiers;
import software.amazon.spapi.models.finances.v2024_06_19.SellingPartnerMetadata;

@Schema(description="Contains all information related to the transaction.")
public class Transaction {
    @SerializedName(value="sellingPartnerMetadata")
    private SellingPartnerMetadata sellingPartnerMetadata = null;
    @SerializedName(value="relatedIdentifiers")
    private RelatedIdentifiers relatedIdentifiers = null;
    @SerializedName(value="transactionType")
    private String transactionType = null;
    @SerializedName(value="transactionId")
    private String transactionId = null;
    @SerializedName(value="transactionStatus")
    private String transactionStatus = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="postedDate")
    private OffsetDateTime postedDate = null;
    @SerializedName(value="totalAmount")
    private Currency totalAmount = null;
    @SerializedName(value="marketplaceDetails")
    private MarketplaceDetails marketplaceDetails = null;
    @SerializedName(value="items")
    private Items items = null;
    @SerializedName(value="contexts")
    private Contexts contexts = null;
    @SerializedName(value="breakdowns")
    private List<Breakdown> breakdowns = null;

    public Transaction sellingPartnerMetadata(SellingPartnerMetadata sellingPartnerMetadata) {
        this.sellingPartnerMetadata = sellingPartnerMetadata;
        return this;
    }

    @Schema(description="")
    public SellingPartnerMetadata getSellingPartnerMetadata() {
        return this.sellingPartnerMetadata;
    }

    public void setSellingPartnerMetadata(SellingPartnerMetadata sellingPartnerMetadata) {
        this.sellingPartnerMetadata = sellingPartnerMetadata;
    }

    public Transaction relatedIdentifiers(RelatedIdentifiers relatedIdentifiers) {
        this.relatedIdentifiers = relatedIdentifiers;
        return this;
    }

    @Schema(description="")
    public RelatedIdentifiers getRelatedIdentifiers() {
        return this.relatedIdentifiers;
    }

    public void setRelatedIdentifiers(RelatedIdentifiers relatedIdentifiers) {
        this.relatedIdentifiers = relatedIdentifiers;
    }

    public Transaction transactionType(String transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @Schema(description="The type of transaction.  Possible values:  * Shipment")
    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public Transaction transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Schema(description="The unique identifier for the transaction.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public Transaction transactionStatus(String transactionStatus) {
        this.transactionStatus = transactionStatus;
        return this;
    }

    @Schema(description="The status of the transaction.  **Possible values:**  * `DEFERRED`: the transaction is currently deferred. * `RELEASED`: the transaction is currently released. * `DEFERRED_RELEASED`: the transaction was deferred in the past, but is now released. The status of a deferred transaction is updated to `DEFERRED_RELEASED` when the transaction is released.")
    public String getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(String transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public Transaction description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Describes the reasons for the transaction.  Example: 'Order Payment','Refund Order'")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Transaction postedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
    }

    public Transaction totalAmount(Currency totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @Schema(description="")
    public Currency getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(Currency totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Transaction marketplaceDetails(MarketplaceDetails marketplaceDetails) {
        this.marketplaceDetails = marketplaceDetails;
        return this;
    }

    @Schema(description="")
    public MarketplaceDetails getMarketplaceDetails() {
        return this.marketplaceDetails;
    }

    public void setMarketplaceDetails(MarketplaceDetails marketplaceDetails) {
        this.marketplaceDetails = marketplaceDetails;
    }

    public Transaction items(Items items) {
        this.items = items;
        return this;
    }

    @Schema(description="")
    public Items getItems() {
        return this.items;
    }

    public void setItems(Items items) {
        this.items = items;
    }

    public Transaction contexts(Contexts contexts) {
        this.contexts = contexts;
        return this;
    }

    @Schema(description="")
    public Contexts getContexts() {
        return this.contexts;
    }

    public void setContexts(Contexts contexts) {
        this.contexts = contexts;
    }

    public Transaction breakdowns(List<Breakdown> breakdowns) {
        this.breakdowns = breakdowns;
        return this;
    }

    public Transaction addBreakdownsItem(Breakdown breakdownsItem) {
        if (this.breakdowns == null) {
            this.breakdowns = new ArrayList<Breakdown>();
        }
        this.breakdowns.add(breakdownsItem);
        return this;
    }

    @Schema(description="A list of breakdowns that detail how the total amount is calculated for the transaction.")
    public List<Breakdown> getBreakdowns() {
        return this.breakdowns;
    }

    public void setBreakdowns(List<Breakdown> breakdowns) {
        this.breakdowns = breakdowns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction transaction = (Transaction)o;
        return Objects.equals(this.sellingPartnerMetadata, transaction.sellingPartnerMetadata) && Objects.equals(this.relatedIdentifiers, transaction.relatedIdentifiers) && Objects.equals(this.transactionType, transaction.transactionType) && Objects.equals(this.transactionId, transaction.transactionId) && Objects.equals(this.transactionStatus, transaction.transactionStatus) && Objects.equals(this.description, transaction.description) && Objects.equals(this.postedDate, transaction.postedDate) && Objects.equals(this.totalAmount, transaction.totalAmount) && Objects.equals(this.marketplaceDetails, transaction.marketplaceDetails) && Objects.equals(this.items, transaction.items) && Objects.equals(this.contexts, transaction.contexts) && Objects.equals(this.breakdowns, transaction.breakdowns);
    }

    public int hashCode() {
        return Objects.hash(this.sellingPartnerMetadata, this.relatedIdentifiers, this.transactionType, this.transactionId, this.transactionStatus, this.description, this.postedDate, this.totalAmount, this.marketplaceDetails, this.items, this.contexts, this.breakdowns);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Transaction {\n");
        sb.append("    sellingPartnerMetadata: ").append(this.toIndentedString(this.sellingPartnerMetadata)).append("\n");
        sb.append("    relatedIdentifiers: ").append(this.toIndentedString(this.relatedIdentifiers)).append("\n");
        sb.append("    transactionType: ").append(this.toIndentedString(this.transactionType)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    transactionStatus: ").append(this.toIndentedString(this.transactionStatus)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("    marketplaceDetails: ").append(this.toIndentedString(this.marketplaceDetails)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    contexts: ").append(this.toIndentedString(this.contexts)).append("\n");
        sb.append("    breakdowns: ").append(this.toIndentedString(this.breakdowns)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

