/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v2024_06_19;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Metadata describing the seller.")
public class SellingPartnerMetadata {
    @SerializedName(value="sellingPartnerId")
    private String sellingPartnerId = null;
    @SerializedName(value="accountType")
    private String accountType = null;
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;

    public SellingPartnerMetadata sellingPartnerId(String sellingPartnerId) {
        this.sellingPartnerId = sellingPartnerId;
        return this;
    }

    @Schema(description="Unique seller identifier.")
    public String getSellingPartnerId() {
        return this.sellingPartnerId;
    }

    public void setSellingPartnerId(String sellingPartnerId) {
        this.sellingPartnerId = sellingPartnerId;
    }

    public SellingPartnerMetadata accountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    @Schema(description="Account type of transaction.")
    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public SellingPartnerMetadata marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(description="The identifier of the marketplace where the transaction occurred. The marketplace ID is the globally unique identifier of a marketplace. To find the ID for your marketplace, refer to [Marketplace IDs](https://developer-docs.amazon.com/sp-api/docs/marketplace-ids).")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SellingPartnerMetadata sellingPartnerMetadata = (SellingPartnerMetadata)o;
        return Objects.equals(this.sellingPartnerId, sellingPartnerMetadata.sellingPartnerId) && Objects.equals(this.accountType, sellingPartnerMetadata.accountType) && Objects.equals(this.marketplaceId, sellingPartnerMetadata.marketplaceId);
    }

    public int hashCode() {
        return Objects.hash(this.sellingPartnerId, this.accountType, this.marketplaceId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SellingPartnerMetadata {\n");
        sb.append("    sellingPartnerId: ").append(this.toIndentedString(this.sellingPartnerId)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString(this.accountType)).append("\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

