/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v2024_06_19;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="Related business identifier of the transaction.")
public class RelatedIdentifier {
    @SerializedName(value="relatedIdentifierName")
    private RelatedIdentifierNameEnum relatedIdentifierName = null;
    @SerializedName(value="relatedIdentifierValue")
    private String relatedIdentifierValue = null;

    public RelatedIdentifier relatedIdentifierName(RelatedIdentifierNameEnum relatedIdentifierName) {
        this.relatedIdentifierName = relatedIdentifierName;
        return this;
    }

    @Schema(description="Enumerated set of related business identifier names.")
    public RelatedIdentifierNameEnum getRelatedIdentifierName() {
        return this.relatedIdentifierName;
    }

    public void setRelatedIdentifierName(RelatedIdentifierNameEnum relatedIdentifierName) {
        this.relatedIdentifierName = relatedIdentifierName;
    }

    public RelatedIdentifier relatedIdentifierValue(String relatedIdentifierValue) {
        this.relatedIdentifierValue = relatedIdentifierValue;
        return this;
    }

    @Schema(description="Corresponding value of RelatedIdentifierName")
    public String getRelatedIdentifierValue() {
        return this.relatedIdentifierValue;
    }

    public void setRelatedIdentifierValue(String relatedIdentifierValue) {
        this.relatedIdentifierValue = relatedIdentifierValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelatedIdentifier relatedIdentifier = (RelatedIdentifier)o;
        return Objects.equals((Object)this.relatedIdentifierName, (Object)relatedIdentifier.relatedIdentifierName) && Objects.equals(this.relatedIdentifierValue, relatedIdentifier.relatedIdentifierValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.relatedIdentifierName, this.relatedIdentifierValue});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RelatedIdentifier {\n");
        sb.append("    relatedIdentifierName: ").append(this.toIndentedString((Object)this.relatedIdentifierName)).append("\n");
        sb.append("    relatedIdentifierValue: ").append(this.toIndentedString(this.relatedIdentifierValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RelatedIdentifierNameEnum {
        ORDER_ID("ORDER_ID"),
        SHIPMENT_ID("SHIPMENT_ID"),
        FINANCIAL_EVENT_GROUP_ID("FINANCIAL_EVENT_GROUP_ID"),
        REFUND_ID("REFUND_ID"),
        INVOICE_ID("INVOICE_ID"),
        DISBURSEMENT_ID("DISBURSEMENT_ID"),
        TRANSFER_ID("TRANSFER_ID"),
        DEFERRED_TRANSACTION_ID("DEFERRED_TRANSACTION_ID"),
        RELEASE_TRANSACTION_ID("RELEASE_TRANSACTION_ID"),
        SETTLEMENT_ID("SETTLEMENT_ID");

        private String value;

        private RelatedIdentifierNameEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RelatedIdentifierNameEnum fromValue(String input) {
            for (RelatedIdentifierNameEnum b : RelatedIdentifierNameEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RelatedIdentifierNameEnum> {
            public void write(JsonWriter jsonWriter, RelatedIdentifierNameEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public RelatedIdentifierNameEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RelatedIdentifierNameEnum.fromValue(value);
            }
        }
    }
}

