/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v2024_06_19;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Information about the marketplace where the transaction occurred.")
public class MarketplaceDetails {
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="marketplaceName")
    private String marketplaceName = null;

    public MarketplaceDetails marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(description="The identifier of the marketplace where the transaction occurred. The marketplace ID is the globally unique identifier of a marketplace. To find the ID for your marketplace, refer to [Marketplace IDs](https://developer-docs.amazon.com/sp-api/docs/marketplace-ids).")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public MarketplaceDetails marketplaceName(String marketplaceName) {
        this.marketplaceName = marketplaceName;
        return this;
    }

    @Schema(description="The name of the marketplace where the transaction occurred.   Example: 'Amazon.com','Amazon.in'")
    public String getMarketplaceName() {
        return this.marketplaceName;
    }

    public void setMarketplaceName(String marketplaceName) {
        this.marketplaceName = marketplaceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketplaceDetails marketplaceDetails = (MarketplaceDetails)o;
        return Objects.equals(this.marketplaceId, marketplaceDetails.marketplaceId) && Objects.equals(this.marketplaceName, marketplaceDetails.marketplaceName);
    }

    public int hashCode() {
        return Objects.hash(this.marketplaceId, this.marketplaceName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MarketplaceDetails {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    marketplaceName: ").append(this.toIndentedString(this.marketplaceName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

