/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v2024_06_19;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="Related business identifiers of the item.")
public class ItemRelatedIdentifier {
    @SerializedName(value="itemRelatedIdentifierName")
    private ItemRelatedIdentifierNameEnum itemRelatedIdentifierName = null;
    @SerializedName(value="itemRelatedIdentifierValue")
    private String itemRelatedIdentifierValue = null;

    public ItemRelatedIdentifier itemRelatedIdentifierName(ItemRelatedIdentifierNameEnum itemRelatedIdentifierName) {
        this.itemRelatedIdentifierName = itemRelatedIdentifierName;
        return this;
    }

    @Schema(description="Enumerated set of related item identifier names for the item.")
    public ItemRelatedIdentifierNameEnum getItemRelatedIdentifierName() {
        return this.itemRelatedIdentifierName;
    }

    public void setItemRelatedIdentifierName(ItemRelatedIdentifierNameEnum itemRelatedIdentifierName) {
        this.itemRelatedIdentifierName = itemRelatedIdentifierName;
    }

    public ItemRelatedIdentifier itemRelatedIdentifierValue(String itemRelatedIdentifierValue) {
        this.itemRelatedIdentifierValue = itemRelatedIdentifierValue;
        return this;
    }

    @Schema(description="Corresponding value of ItemRelatedIdentifierName")
    public String getItemRelatedIdentifierValue() {
        return this.itemRelatedIdentifierValue;
    }

    public void setItemRelatedIdentifierValue(String itemRelatedIdentifierValue) {
        this.itemRelatedIdentifierValue = itemRelatedIdentifierValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemRelatedIdentifier itemRelatedIdentifier = (ItemRelatedIdentifier)o;
        return Objects.equals((Object)this.itemRelatedIdentifierName, (Object)itemRelatedIdentifier.itemRelatedIdentifierName) && Objects.equals(this.itemRelatedIdentifierValue, itemRelatedIdentifier.itemRelatedIdentifierValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.itemRelatedIdentifierName, this.itemRelatedIdentifierValue});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemRelatedIdentifier {\n");
        sb.append("    itemRelatedIdentifierName: ").append(this.toIndentedString((Object)this.itemRelatedIdentifierName)).append("\n");
        sb.append("    itemRelatedIdentifierValue: ").append(this.toIndentedString(this.itemRelatedIdentifierValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ItemRelatedIdentifierNameEnum {
        ORDER_ADJUSTMENT_ITEM_ID("ORDER_ADJUSTMENT_ITEM_ID"),
        COUPON_ID("COUPON_ID"),
        REMOVAL_SHIPMENT_ITEM_ID("REMOVAL_SHIPMENT_ITEM_ID"),
        TRANSACTION_ID("TRANSACTION_ID");

        private String value;

        private ItemRelatedIdentifierNameEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ItemRelatedIdentifierNameEnum fromValue(String input) {
            for (ItemRelatedIdentifierNameEnum b : ItemRelatedIdentifierNameEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ItemRelatedIdentifierNameEnum> {
            public void write(JsonWriter jsonWriter, ItemRelatedIdentifierNameEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ItemRelatedIdentifierNameEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ItemRelatedIdentifierNameEnum.fromValue(value);
            }
        }
    }
}

