/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v2024_06_19;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@Schema(description="Additional information related to Deferred transactions.")
public class DeferredContext {
    @SerializedName(value="deferralReason")
    private String deferralReason = null;
    @SerializedName(value="maturityDate")
    private OffsetDateTime maturityDate = null;

    public DeferredContext deferralReason(String deferralReason) {
        this.deferralReason = deferralReason;
        return this;
    }

    @Schema(description="The deferral policy applied to the transaction.  **Examples:** `B2B` (invoiced orders), `DD7` (delivery date policy)")
    public String getDeferralReason() {
        return this.deferralReason;
    }

    public void setDeferralReason(String deferralReason) {
        this.deferralReason = deferralReason;
    }

    public DeferredContext maturityDate(OffsetDateTime maturityDate) {
        this.maturityDate = maturityDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getMaturityDate() {
        return this.maturityDate;
    }

    public void setMaturityDate(OffsetDateTime maturityDate) {
        this.maturityDate = maturityDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeferredContext deferredContext = (DeferredContext)o;
        return Objects.equals(this.deferralReason, deferredContext.deferralReason) && Objects.equals(this.maturityDate, deferredContext.maturityDate);
    }

    public int hashCode() {
        return Objects.hash(this.deferralReason, this.maturityDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeferredContext {\n");
        sb.append("    deferralReason: ").append(this.toIndentedString(this.deferralReason)).append("\n");
        sb.append("    maturityDate: ").append(this.toIndentedString(this.maturityDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

