/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v2024_06_19;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@Schema(description="Additional Information about the item.")
public class Context {
    @SerializedName(value="contextType")
    private String contextType = null;
    @SerializedName(value="storeName")
    private StoreNameEnum storeName = null;
    @SerializedName(value="orderType")
    private String orderType = null;
    @SerializedName(value="channel")
    private String channel = null;
    @SerializedName(value="asin")
    private String asin = null;
    @SerializedName(value="sku")
    private String sku = null;
    @SerializedName(value="quantityShipped")
    private Integer quantityShipped = null;
    @SerializedName(value="fulfillmentNetwork")
    private String fulfillmentNetwork = null;
    @SerializedName(value="paymentType")
    private String paymentType = null;
    @SerializedName(value="paymentMethod")
    private String paymentMethod = null;
    @SerializedName(value="paymentReference")
    private String paymentReference = null;
    @SerializedName(value="paymentDate")
    private OffsetDateTime paymentDate = null;
    @SerializedName(value="deferralReason")
    private String deferralReason = null;
    @SerializedName(value="maturityDate")
    private OffsetDateTime maturityDate = null;
    @SerializedName(value="startTime")
    private OffsetDateTime startTime = null;
    @SerializedName(value="endTime")
    private OffsetDateTime endTime = null;

    public Context contextType(String contextType) {
        this.contextType = contextType;
        return this;
    }

    @Schema(required=true, description="")
    public String getContextType() {
        return this.contextType;
    }

    public void setContextType(String contextType) {
        this.contextType = contextType;
    }

    public Context storeName(StoreNameEnum storeName) {
        this.storeName = storeName;
        return this;
    }

    @Schema(description="The store name associated with the transaction.")
    public StoreNameEnum getStoreName() {
        return this.storeName;
    }

    public void setStoreName(StoreNameEnum storeName) {
        this.storeName = storeName;
    }

    public Context orderType(String orderType) {
        this.orderType = orderType;
        return this;
    }

    @Schema(description="Order type of the transaction.")
    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public Context channel(String channel) {
        this.channel = channel;
        return this;
    }

    @Schema(description="Channel details of related transaction.")
    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public Context asin(String asin) {
        this.asin = asin;
        return this;
    }

    @Schema(description="Amazon Standard Identification Number (ASIN) of the item.")
    public String getAsin() {
        return this.asin;
    }

    public void setAsin(String asin) {
        this.asin = asin;
    }

    public Context sku(String sku) {
        this.sku = sku;
        return this;
    }

    @Schema(description="Stock keeping unit (SKU) of the item.")
    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public Context quantityShipped(Integer quantityShipped) {
        this.quantityShipped = quantityShipped;
        return this;
    }

    @Schema(description="Quantity of the item shipped.")
    public Integer getQuantityShipped() {
        return this.quantityShipped;
    }

    public void setQuantityShipped(Integer quantityShipped) {
        this.quantityShipped = quantityShipped;
    }

    public Context fulfillmentNetwork(String fulfillmentNetwork) {
        this.fulfillmentNetwork = fulfillmentNetwork;
        return this;
    }

    @Schema(description="Fulfillment network of the item.")
    public String getFulfillmentNetwork() {
        return this.fulfillmentNetwork;
    }

    public void setFulfillmentNetwork(String fulfillmentNetwork) {
        this.fulfillmentNetwork = fulfillmentNetwork;
    }

    public Context paymentType(String paymentType) {
        this.paymentType = paymentType;
        return this;
    }

    @Schema(description="Type of payment made.")
    public String getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    public Context paymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @Schema(description="Method of payment made.")
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public Context paymentReference(String paymentReference) {
        this.paymentReference = paymentReference;
        return this;
    }

    @Schema(description="Reference number of payment made.")
    public String getPaymentReference() {
        return this.paymentReference;
    }

    public void setPaymentReference(String paymentReference) {
        this.paymentReference = paymentReference;
    }

    public Context paymentDate(OffsetDateTime paymentDate) {
        this.paymentDate = paymentDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(OffsetDateTime paymentDate) {
        this.paymentDate = paymentDate;
    }

    public Context deferralReason(String deferralReason) {
        this.deferralReason = deferralReason;
        return this;
    }

    @Schema(description="The deferral policy applied to the transaction.  **Examples:** `B2B` (invoiced orders), `DD7` (delivery date policy)")
    public String getDeferralReason() {
        return this.deferralReason;
    }

    public void setDeferralReason(String deferralReason) {
        this.deferralReason = deferralReason;
    }

    public Context maturityDate(OffsetDateTime maturityDate) {
        this.maturityDate = maturityDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getMaturityDate() {
        return this.maturityDate;
    }

    public void setMaturityDate(OffsetDateTime maturityDate) {
        this.maturityDate = maturityDate;
    }

    public Context startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public Context endTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Context context = (Context)o;
        return Objects.equals(this.contextType, context.contextType) && Objects.equals((Object)this.storeName, (Object)context.storeName) && Objects.equals(this.orderType, context.orderType) && Objects.equals(this.channel, context.channel) && Objects.equals(this.asin, context.asin) && Objects.equals(this.sku, context.sku) && Objects.equals(this.quantityShipped, context.quantityShipped) && Objects.equals(this.fulfillmentNetwork, context.fulfillmentNetwork) && Objects.equals(this.paymentType, context.paymentType) && Objects.equals(this.paymentMethod, context.paymentMethod) && Objects.equals(this.paymentReference, context.paymentReference) && Objects.equals(this.paymentDate, context.paymentDate) && Objects.equals(this.deferralReason, context.deferralReason) && Objects.equals(this.maturityDate, context.maturityDate) && Objects.equals(this.startTime, context.startTime) && Objects.equals(this.endTime, context.endTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contextType, this.storeName, this.orderType, this.channel, this.asin, this.sku, this.quantityShipped, this.fulfillmentNetwork, this.paymentType, this.paymentMethod, this.paymentReference, this.paymentDate, this.deferralReason, this.maturityDate, this.startTime, this.endTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Context {\n");
        sb.append("    contextType: ").append(this.toIndentedString(this.contextType)).append("\n");
        sb.append("    storeName: ").append(this.toIndentedString((Object)this.storeName)).append("\n");
        sb.append("    orderType: ").append(this.toIndentedString(this.orderType)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString(this.channel)).append("\n");
        sb.append("    asin: ").append(this.toIndentedString(this.asin)).append("\n");
        sb.append("    sku: ").append(this.toIndentedString(this.sku)).append("\n");
        sb.append("    quantityShipped: ").append(this.toIndentedString(this.quantityShipped)).append("\n");
        sb.append("    fulfillmentNetwork: ").append(this.toIndentedString(this.fulfillmentNetwork)).append("\n");
        sb.append("    paymentType: ").append(this.toIndentedString(this.paymentType)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    paymentReference: ").append(this.toIndentedString(this.paymentReference)).append("\n");
        sb.append("    paymentDate: ").append(this.toIndentedString(this.paymentDate)).append("\n");
        sb.append("    deferralReason: ").append(this.toIndentedString(this.deferralReason)).append("\n");
        sb.append("    maturityDate: ").append(this.toIndentedString(this.maturityDate)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StoreNameEnum {
        AMAZON_HAUL("AMAZON_HAUL");

        private String value;

        private StoreNameEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StoreNameEnum fromValue(String input) {
            for (StoreNameEnum b : StoreNameEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StoreNameEnum> {
            public void write(JsonWriter jsonWriter, StoreNameEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public StoreNameEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StoreNameEnum.fromValue(value);
            }
        }
    }
}

