/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.finances.v0.Currency;

@Schema(description="An event related to a value added service charge.")
public class ValueAddedServiceChargeEvent {
    @SerializedName(value="TransactionType")
    private String transactionType = null;
    @SerializedName(value="PostedDate")
    private OffsetDateTime postedDate = null;
    @SerializedName(value="Description")
    private String description = null;
    @SerializedName(value="TransactionAmount")
    private Currency transactionAmount = null;

    public ValueAddedServiceChargeEvent transactionType(String transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @Schema(description="Indicates the type of transaction.  Example: 'Other Support Service fees'")
    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public ValueAddedServiceChargeEvent postedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
    }

    public ValueAddedServiceChargeEvent description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A short description of the service charge event.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ValueAddedServiceChargeEvent transactionAmount(Currency transactionAmount) {
        this.transactionAmount = transactionAmount;
        return this;
    }

    @Schema(description="")
    public Currency getTransactionAmount() {
        return this.transactionAmount;
    }

    public void setTransactionAmount(Currency transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueAddedServiceChargeEvent valueAddedServiceChargeEvent = (ValueAddedServiceChargeEvent)o;
        return Objects.equals(this.transactionType, valueAddedServiceChargeEvent.transactionType) && Objects.equals(this.postedDate, valueAddedServiceChargeEvent.postedDate) && Objects.equals(this.description, valueAddedServiceChargeEvent.description) && Objects.equals(this.transactionAmount, valueAddedServiceChargeEvent.transactionAmount);
    }

    public int hashCode() {
        return Objects.hash(this.transactionType, this.postedDate, this.description, this.transactionAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ValueAddedServiceChargeEvent {\n");
        sb.append("    transactionType: ").append(this.toIndentedString(this.transactionType)).append("\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    transactionAmount: ").append(this.toIndentedString(this.transactionAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

