/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.finances.v0.Currency;
import software.amazon.spapi.models.finances.v0.TaxWithholdingPeriod;

@Schema(description="A TaxWithholding event on seller's account.")
public class TaxWithholdingEvent {
    @SerializedName(value="PostedDate")
    private OffsetDateTime postedDate = null;
    @SerializedName(value="BaseAmount")
    private Currency baseAmount = null;
    @SerializedName(value="WithheldAmount")
    private Currency withheldAmount = null;
    @SerializedName(value="TaxWithholdingPeriod")
    private TaxWithholdingPeriod taxWithholdingPeriod = null;

    public TaxWithholdingEvent postedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
    }

    public TaxWithholdingEvent baseAmount(Currency baseAmount) {
        this.baseAmount = baseAmount;
        return this;
    }

    @Schema(description="")
    public Currency getBaseAmount() {
        return this.baseAmount;
    }

    public void setBaseAmount(Currency baseAmount) {
        this.baseAmount = baseAmount;
    }

    public TaxWithholdingEvent withheldAmount(Currency withheldAmount) {
        this.withheldAmount = withheldAmount;
        return this;
    }

    @Schema(description="")
    public Currency getWithheldAmount() {
        return this.withheldAmount;
    }

    public void setWithheldAmount(Currency withheldAmount) {
        this.withheldAmount = withheldAmount;
    }

    public TaxWithholdingEvent taxWithholdingPeriod(TaxWithholdingPeriod taxWithholdingPeriod) {
        this.taxWithholdingPeriod = taxWithholdingPeriod;
        return this;
    }

    @Schema(description="")
    public TaxWithholdingPeriod getTaxWithholdingPeriod() {
        return this.taxWithholdingPeriod;
    }

    public void setTaxWithholdingPeriod(TaxWithholdingPeriod taxWithholdingPeriod) {
        this.taxWithholdingPeriod = taxWithholdingPeriod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxWithholdingEvent taxWithholdingEvent = (TaxWithholdingEvent)o;
        return Objects.equals(this.postedDate, taxWithholdingEvent.postedDate) && Objects.equals(this.baseAmount, taxWithholdingEvent.baseAmount) && Objects.equals(this.withheldAmount, taxWithholdingEvent.withheldAmount) && Objects.equals(this.taxWithholdingPeriod, taxWithholdingEvent.taxWithholdingPeriod);
    }

    public int hashCode() {
        return Objects.hash(this.postedDate, this.baseAmount, this.withheldAmount, this.taxWithholdingPeriod);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxWithholdingEvent {\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    baseAmount: ").append(this.toIndentedString(this.baseAmount)).append("\n");
        sb.append("    withheldAmount: ").append(this.toIndentedString(this.withheldAmount)).append("\n");
        sb.append("    taxWithholdingPeriod: ").append(this.toIndentedString(this.taxWithholdingPeriod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

