/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.finances.v0.Currency;

@Schema(description="A credit given to a solution provider.")
public class SolutionProviderCreditEvent {
    @SerializedName(value="ProviderTransactionType")
    private String providerTransactionType = null;
    @SerializedName(value="SellerOrderId")
    private String sellerOrderId = null;
    @SerializedName(value="MarketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="MarketplaceCountryCode")
    private String marketplaceCountryCode = null;
    @SerializedName(value="SellerId")
    private String sellerId = null;
    @SerializedName(value="SellerStoreName")
    private String sellerStoreName = null;
    @SerializedName(value="ProviderId")
    private String providerId = null;
    @SerializedName(value="ProviderStoreName")
    private String providerStoreName = null;
    @SerializedName(value="TransactionAmount")
    private Currency transactionAmount = null;
    @SerializedName(value="TransactionCreationDate")
    private OffsetDateTime transactionCreationDate = null;

    public SolutionProviderCreditEvent providerTransactionType(String providerTransactionType) {
        this.providerTransactionType = providerTransactionType;
        return this;
    }

    @Schema(description="The transaction type.")
    public String getProviderTransactionType() {
        return this.providerTransactionType;
    }

    public void setProviderTransactionType(String providerTransactionType) {
        this.providerTransactionType = providerTransactionType;
    }

    public SolutionProviderCreditEvent sellerOrderId(String sellerOrderId) {
        this.sellerOrderId = sellerOrderId;
        return this;
    }

    @Schema(description="A seller-defined identifier for an order.")
    public String getSellerOrderId() {
        return this.sellerOrderId;
    }

    public void setSellerOrderId(String sellerOrderId) {
        this.sellerOrderId = sellerOrderId;
    }

    public SolutionProviderCreditEvent marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(description="The identifier of the marketplace where the order was placed.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public SolutionProviderCreditEvent marketplaceCountryCode(String marketplaceCountryCode) {
        this.marketplaceCountryCode = marketplaceCountryCode;
        return this;
    }

    @Schema(description="The two-letter country code of the country associated with the marketplace where the order was placed.")
    public String getMarketplaceCountryCode() {
        return this.marketplaceCountryCode;
    }

    public void setMarketplaceCountryCode(String marketplaceCountryCode) {
        this.marketplaceCountryCode = marketplaceCountryCode;
    }

    public SolutionProviderCreditEvent sellerId(String sellerId) {
        this.sellerId = sellerId;
        return this;
    }

    @Schema(description="The Amazon-defined identifier of the seller.")
    public String getSellerId() {
        return this.sellerId;
    }

    public void setSellerId(String sellerId) {
        this.sellerId = sellerId;
    }

    public SolutionProviderCreditEvent sellerStoreName(String sellerStoreName) {
        this.sellerStoreName = sellerStoreName;
        return this;
    }

    @Schema(description="The store name where the payment event occurred.")
    public String getSellerStoreName() {
        return this.sellerStoreName;
    }

    public void setSellerStoreName(String sellerStoreName) {
        this.sellerStoreName = sellerStoreName;
    }

    public SolutionProviderCreditEvent providerId(String providerId) {
        this.providerId = providerId;
        return this;
    }

    @Schema(description="The Amazon-defined identifier of the solution provider.")
    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public SolutionProviderCreditEvent providerStoreName(String providerStoreName) {
        this.providerStoreName = providerStoreName;
        return this;
    }

    @Schema(description="The store name where the payment event occurred.")
    public String getProviderStoreName() {
        return this.providerStoreName;
    }

    public void setProviderStoreName(String providerStoreName) {
        this.providerStoreName = providerStoreName;
    }

    public SolutionProviderCreditEvent transactionAmount(Currency transactionAmount) {
        this.transactionAmount = transactionAmount;
        return this;
    }

    @Schema(description="")
    public Currency getTransactionAmount() {
        return this.transactionAmount;
    }

    public void setTransactionAmount(Currency transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    public SolutionProviderCreditEvent transactionCreationDate(OffsetDateTime transactionCreationDate) {
        this.transactionCreationDate = transactionCreationDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getTransactionCreationDate() {
        return this.transactionCreationDate;
    }

    public void setTransactionCreationDate(OffsetDateTime transactionCreationDate) {
        this.transactionCreationDate = transactionCreationDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SolutionProviderCreditEvent solutionProviderCreditEvent = (SolutionProviderCreditEvent)o;
        return Objects.equals(this.providerTransactionType, solutionProviderCreditEvent.providerTransactionType) && Objects.equals(this.sellerOrderId, solutionProviderCreditEvent.sellerOrderId) && Objects.equals(this.marketplaceId, solutionProviderCreditEvent.marketplaceId) && Objects.equals(this.marketplaceCountryCode, solutionProviderCreditEvent.marketplaceCountryCode) && Objects.equals(this.sellerId, solutionProviderCreditEvent.sellerId) && Objects.equals(this.sellerStoreName, solutionProviderCreditEvent.sellerStoreName) && Objects.equals(this.providerId, solutionProviderCreditEvent.providerId) && Objects.equals(this.providerStoreName, solutionProviderCreditEvent.providerStoreName) && Objects.equals(this.transactionAmount, solutionProviderCreditEvent.transactionAmount) && Objects.equals(this.transactionCreationDate, solutionProviderCreditEvent.transactionCreationDate);
    }

    public int hashCode() {
        return Objects.hash(this.providerTransactionType, this.sellerOrderId, this.marketplaceId, this.marketplaceCountryCode, this.sellerId, this.sellerStoreName, this.providerId, this.providerStoreName, this.transactionAmount, this.transactionCreationDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SolutionProviderCreditEvent {\n");
        sb.append("    providerTransactionType: ").append(this.toIndentedString(this.providerTransactionType)).append("\n");
        sb.append("    sellerOrderId: ").append(this.toIndentedString(this.sellerOrderId)).append("\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    marketplaceCountryCode: ").append(this.toIndentedString(this.marketplaceCountryCode)).append("\n");
        sb.append("    sellerId: ").append(this.toIndentedString(this.sellerId)).append("\n");
        sb.append("    sellerStoreName: ").append(this.toIndentedString(this.sellerStoreName)).append("\n");
        sb.append("    providerId: ").append(this.toIndentedString(this.providerId)).append("\n");
        sb.append("    providerStoreName: ").append(this.toIndentedString(this.providerStoreName)).append("\n");
        sb.append("    transactionAmount: ").append(this.toIndentedString(this.transactionAmount)).append("\n");
        sb.append("    transactionCreationDate: ").append(this.toIndentedString(this.transactionCreationDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

