/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.finances.v0.Currency;

@Schema(description="An event linked to the payment of a fee related to the specified deal.")
public class SellerDealPaymentEvent {
    @SerializedName(value="postedDate")
    private OffsetDateTime postedDate = null;
    @SerializedName(value="dealId")
    private String dealId = null;
    @SerializedName(value="dealDescription")
    private String dealDescription = null;
    @SerializedName(value="eventType")
    private String eventType = null;
    @SerializedName(value="feeType")
    private String feeType = null;
    @SerializedName(value="feeAmount")
    private Currency feeAmount = null;
    @SerializedName(value="taxAmount")
    private Currency taxAmount = null;
    @SerializedName(value="totalAmount")
    private Currency totalAmount = null;

    public SellerDealPaymentEvent postedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
    }

    public SellerDealPaymentEvent dealId(String dealId) {
        this.dealId = dealId;
        return this;
    }

    @Schema(description="The unique identifier of the deal.")
    public String getDealId() {
        return this.dealId;
    }

    public void setDealId(String dealId) {
        this.dealId = dealId;
    }

    public SellerDealPaymentEvent dealDescription(String dealDescription) {
        this.dealDescription = dealDescription;
        return this;
    }

    @Schema(description="The internal description of the deal.")
    public String getDealDescription() {
        return this.dealDescription;
    }

    public void setDealDescription(String dealDescription) {
        this.dealDescription = dealDescription;
    }

    public SellerDealPaymentEvent eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @Schema(description="The type of event: SellerDealComplete.")
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public SellerDealPaymentEvent feeType(String feeType) {
        this.feeType = feeType;
        return this;
    }

    @Schema(description="The type of fee: RunLightningDealFee.")
    public String getFeeType() {
        return this.feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public SellerDealPaymentEvent feeAmount(Currency feeAmount) {
        this.feeAmount = feeAmount;
        return this;
    }

    @Schema(description="")
    public Currency getFeeAmount() {
        return this.feeAmount;
    }

    public void setFeeAmount(Currency feeAmount) {
        this.feeAmount = feeAmount;
    }

    public SellerDealPaymentEvent taxAmount(Currency taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    @Schema(description="")
    public Currency getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(Currency taxAmount) {
        this.taxAmount = taxAmount;
    }

    public SellerDealPaymentEvent totalAmount(Currency totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @Schema(description="")
    public Currency getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(Currency totalAmount) {
        this.totalAmount = totalAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SellerDealPaymentEvent sellerDealPaymentEvent = (SellerDealPaymentEvent)o;
        return Objects.equals(this.postedDate, sellerDealPaymentEvent.postedDate) && Objects.equals(this.dealId, sellerDealPaymentEvent.dealId) && Objects.equals(this.dealDescription, sellerDealPaymentEvent.dealDescription) && Objects.equals(this.eventType, sellerDealPaymentEvent.eventType) && Objects.equals(this.feeType, sellerDealPaymentEvent.feeType) && Objects.equals(this.feeAmount, sellerDealPaymentEvent.feeAmount) && Objects.equals(this.taxAmount, sellerDealPaymentEvent.taxAmount) && Objects.equals(this.totalAmount, sellerDealPaymentEvent.totalAmount);
    }

    public int hashCode() {
        return Objects.hash(this.postedDate, this.dealId, this.dealDescription, this.eventType, this.feeType, this.feeAmount, this.taxAmount, this.totalAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SellerDealPaymentEvent {\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    dealId: ").append(this.toIndentedString(this.dealId)).append("\n");
        sb.append("    dealDescription: ").append(this.toIndentedString(this.dealDescription)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    feeType: ").append(this.toIndentedString(this.feeType)).append("\n");
        sb.append("    feeAmount: ").append(this.toIndentedString(this.feeAmount)).append("\n");
        sb.append("    taxAmount: ").append(this.toIndentedString(this.taxAmount)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

