/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.finances.v0.Currency;

@Schema(description="Item-level information for a removal shipment item adjustment.")
public class RemovalShipmentItemAdjustment {
    @SerializedName(value="RemovalShipmentItemId")
    private String removalShipmentItemId = null;
    @SerializedName(value="TaxCollectionModel")
    private String taxCollectionModel = null;
    @SerializedName(value="FulfillmentNetworkSKU")
    private String fulfillmentNetworkSKU = null;
    @SerializedName(value="AdjustedQuantity")
    private Integer adjustedQuantity = null;
    @SerializedName(value="RevenueAdjustment")
    private Currency revenueAdjustment = null;
    @SerializedName(value="TaxAmountAdjustment")
    private Currency taxAmountAdjustment = null;
    @SerializedName(value="TaxWithheldAdjustment")
    private Currency taxWithheldAdjustment = null;

    public RemovalShipmentItemAdjustment removalShipmentItemId(String removalShipmentItemId) {
        this.removalShipmentItemId = removalShipmentItemId;
        return this;
    }

    @Schema(description="An identifier for an item in a removal shipment.")
    public String getRemovalShipmentItemId() {
        return this.removalShipmentItemId;
    }

    public void setRemovalShipmentItemId(String removalShipmentItemId) {
        this.removalShipmentItemId = removalShipmentItemId;
    }

    public RemovalShipmentItemAdjustment taxCollectionModel(String taxCollectionModel) {
        this.taxCollectionModel = taxCollectionModel;
        return this;
    }

    @Schema(description="The tax collection model applied to the item.  Possible values:  * MarketplaceFacilitator - Tax is withheld and remitted to the taxing authority by Amazon on behalf of the seller.  * Standard - Tax is paid to the seller and not remitted to the taxing authority by Amazon.")
    public String getTaxCollectionModel() {
        return this.taxCollectionModel;
    }

    public void setTaxCollectionModel(String taxCollectionModel) {
        this.taxCollectionModel = taxCollectionModel;
    }

    public RemovalShipmentItemAdjustment fulfillmentNetworkSKU(String fulfillmentNetworkSKU) {
        this.fulfillmentNetworkSKU = fulfillmentNetworkSKU;
        return this;
    }

    @Schema(description="The Amazon fulfillment network SKU for the item.")
    public String getFulfillmentNetworkSKU() {
        return this.fulfillmentNetworkSKU;
    }

    public void setFulfillmentNetworkSKU(String fulfillmentNetworkSKU) {
        this.fulfillmentNetworkSKU = fulfillmentNetworkSKU;
    }

    public RemovalShipmentItemAdjustment adjustedQuantity(Integer adjustedQuantity) {
        this.adjustedQuantity = adjustedQuantity;
        return this;
    }

    @Schema(description="Adjusted quantity of removal shipmentItemAdjustment items.")
    public Integer getAdjustedQuantity() {
        return this.adjustedQuantity;
    }

    public void setAdjustedQuantity(Integer adjustedQuantity) {
        this.adjustedQuantity = adjustedQuantity;
    }

    public RemovalShipmentItemAdjustment revenueAdjustment(Currency revenueAdjustment) {
        this.revenueAdjustment = revenueAdjustment;
        return this;
    }

    @Schema(description="")
    public Currency getRevenueAdjustment() {
        return this.revenueAdjustment;
    }

    public void setRevenueAdjustment(Currency revenueAdjustment) {
        this.revenueAdjustment = revenueAdjustment;
    }

    public RemovalShipmentItemAdjustment taxAmountAdjustment(Currency taxAmountAdjustment) {
        this.taxAmountAdjustment = taxAmountAdjustment;
        return this;
    }

    @Schema(description="")
    public Currency getTaxAmountAdjustment() {
        return this.taxAmountAdjustment;
    }

    public void setTaxAmountAdjustment(Currency taxAmountAdjustment) {
        this.taxAmountAdjustment = taxAmountAdjustment;
    }

    public RemovalShipmentItemAdjustment taxWithheldAdjustment(Currency taxWithheldAdjustment) {
        this.taxWithheldAdjustment = taxWithheldAdjustment;
        return this;
    }

    @Schema(description="")
    public Currency getTaxWithheldAdjustment() {
        return this.taxWithheldAdjustment;
    }

    public void setTaxWithheldAdjustment(Currency taxWithheldAdjustment) {
        this.taxWithheldAdjustment = taxWithheldAdjustment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemovalShipmentItemAdjustment removalShipmentItemAdjustment = (RemovalShipmentItemAdjustment)o;
        return Objects.equals(this.removalShipmentItemId, removalShipmentItemAdjustment.removalShipmentItemId) && Objects.equals(this.taxCollectionModel, removalShipmentItemAdjustment.taxCollectionModel) && Objects.equals(this.fulfillmentNetworkSKU, removalShipmentItemAdjustment.fulfillmentNetworkSKU) && Objects.equals(this.adjustedQuantity, removalShipmentItemAdjustment.adjustedQuantity) && Objects.equals(this.revenueAdjustment, removalShipmentItemAdjustment.revenueAdjustment) && Objects.equals(this.taxAmountAdjustment, removalShipmentItemAdjustment.taxAmountAdjustment) && Objects.equals(this.taxWithheldAdjustment, removalShipmentItemAdjustment.taxWithheldAdjustment);
    }

    public int hashCode() {
        return Objects.hash(this.removalShipmentItemId, this.taxCollectionModel, this.fulfillmentNetworkSKU, this.adjustedQuantity, this.revenueAdjustment, this.taxAmountAdjustment, this.taxWithheldAdjustment);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RemovalShipmentItemAdjustment {\n");
        sb.append("    removalShipmentItemId: ").append(this.toIndentedString(this.removalShipmentItemId)).append("\n");
        sb.append("    taxCollectionModel: ").append(this.toIndentedString(this.taxCollectionModel)).append("\n");
        sb.append("    fulfillmentNetworkSKU: ").append(this.toIndentedString(this.fulfillmentNetworkSKU)).append("\n");
        sb.append("    adjustedQuantity: ").append(this.toIndentedString(this.adjustedQuantity)).append("\n");
        sb.append("    revenueAdjustment: ").append(this.toIndentedString(this.revenueAdjustment)).append("\n");
        sb.append("    taxAmountAdjustment: ").append(this.toIndentedString(this.taxAmountAdjustment)).append("\n");
        sb.append("    taxWithheldAdjustment: ").append(this.toIndentedString(this.taxWithheldAdjustment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

