/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.finances.v0.Currency;

@Schema(description="Item-level information for a removal shipment.")
public class RemovalShipmentItem {
    @SerializedName(value="RemovalShipmentItemId")
    private String removalShipmentItemId = null;
    @SerializedName(value="TaxCollectionModel")
    private String taxCollectionModel = null;
    @SerializedName(value="FulfillmentNetworkSKU")
    private String fulfillmentNetworkSKU = null;
    @SerializedName(value="Quantity")
    private Integer quantity = null;
    @SerializedName(value="Revenue")
    private Currency revenue = null;
    @SerializedName(value="FeeAmount")
    private Currency feeAmount = null;
    @SerializedName(value="TaxAmount")
    private Currency taxAmount = null;
    @SerializedName(value="TaxWithheld")
    private Currency taxWithheld = null;

    public RemovalShipmentItem removalShipmentItemId(String removalShipmentItemId) {
        this.removalShipmentItemId = removalShipmentItemId;
        return this;
    }

    @Schema(description="An identifier for an item in a removal shipment.")
    public String getRemovalShipmentItemId() {
        return this.removalShipmentItemId;
    }

    public void setRemovalShipmentItemId(String removalShipmentItemId) {
        this.removalShipmentItemId = removalShipmentItemId;
    }

    public RemovalShipmentItem taxCollectionModel(String taxCollectionModel) {
        this.taxCollectionModel = taxCollectionModel;
        return this;
    }

    @Schema(description="The tax collection model applied to the item.  Possible values:  * MarketplaceFacilitator - Tax is withheld and remitted to the taxing authority by Amazon on behalf of the seller.  * Standard - Tax is paid to the seller and not remitted to the taxing authority by Amazon.")
    public String getTaxCollectionModel() {
        return this.taxCollectionModel;
    }

    public void setTaxCollectionModel(String taxCollectionModel) {
        this.taxCollectionModel = taxCollectionModel;
    }

    public RemovalShipmentItem fulfillmentNetworkSKU(String fulfillmentNetworkSKU) {
        this.fulfillmentNetworkSKU = fulfillmentNetworkSKU;
        return this;
    }

    @Schema(description="The Amazon fulfillment network SKU for the item.")
    public String getFulfillmentNetworkSKU() {
        return this.fulfillmentNetworkSKU;
    }

    public void setFulfillmentNetworkSKU(String fulfillmentNetworkSKU) {
        this.fulfillmentNetworkSKU = fulfillmentNetworkSKU;
    }

    public RemovalShipmentItem quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Schema(description="The quantity of the item.")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public RemovalShipmentItem revenue(Currency revenue) {
        this.revenue = revenue;
        return this;
    }

    @Schema(description="")
    public Currency getRevenue() {
        return this.revenue;
    }

    public void setRevenue(Currency revenue) {
        this.revenue = revenue;
    }

    public RemovalShipmentItem feeAmount(Currency feeAmount) {
        this.feeAmount = feeAmount;
        return this;
    }

    @Schema(description="")
    public Currency getFeeAmount() {
        return this.feeAmount;
    }

    public void setFeeAmount(Currency feeAmount) {
        this.feeAmount = feeAmount;
    }

    public RemovalShipmentItem taxAmount(Currency taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    @Schema(description="")
    public Currency getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(Currency taxAmount) {
        this.taxAmount = taxAmount;
    }

    public RemovalShipmentItem taxWithheld(Currency taxWithheld) {
        this.taxWithheld = taxWithheld;
        return this;
    }

    @Schema(description="")
    public Currency getTaxWithheld() {
        return this.taxWithheld;
    }

    public void setTaxWithheld(Currency taxWithheld) {
        this.taxWithheld = taxWithheld;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemovalShipmentItem removalShipmentItem = (RemovalShipmentItem)o;
        return Objects.equals(this.removalShipmentItemId, removalShipmentItem.removalShipmentItemId) && Objects.equals(this.taxCollectionModel, removalShipmentItem.taxCollectionModel) && Objects.equals(this.fulfillmentNetworkSKU, removalShipmentItem.fulfillmentNetworkSKU) && Objects.equals(this.quantity, removalShipmentItem.quantity) && Objects.equals(this.revenue, removalShipmentItem.revenue) && Objects.equals(this.feeAmount, removalShipmentItem.feeAmount) && Objects.equals(this.taxAmount, removalShipmentItem.taxAmount) && Objects.equals(this.taxWithheld, removalShipmentItem.taxWithheld);
    }

    public int hashCode() {
        return Objects.hash(this.removalShipmentItemId, this.taxCollectionModel, this.fulfillmentNetworkSKU, this.quantity, this.revenue, this.feeAmount, this.taxAmount, this.taxWithheld);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RemovalShipmentItem {\n");
        sb.append("    removalShipmentItemId: ").append(this.toIndentedString(this.removalShipmentItemId)).append("\n");
        sb.append("    taxCollectionModel: ").append(this.toIndentedString(this.taxCollectionModel)).append("\n");
        sb.append("    fulfillmentNetworkSKU: ").append(this.toIndentedString(this.fulfillmentNetworkSKU)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    revenue: ").append(this.toIndentedString(this.revenue)).append("\n");
        sb.append("    feeAmount: ").append(this.toIndentedString(this.feeAmount)).append("\n");
        sb.append("    taxAmount: ").append(this.toIndentedString(this.taxAmount)).append("\n");
        sb.append("    taxWithheld: ").append(this.toIndentedString(this.taxWithheld)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

