/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.finances.v0.Currency;

@Schema(description="A Sponsored Products payment event.")
public class ProductAdsPaymentEvent {
    @SerializedName(value="postedDate")
    private OffsetDateTime postedDate = null;
    @SerializedName(value="transactionType")
    private String transactionType = null;
    @SerializedName(value="invoiceId")
    private String invoiceId = null;
    @SerializedName(value="baseValue")
    private Currency baseValue = null;
    @SerializedName(value="taxValue")
    private Currency taxValue = null;
    @SerializedName(value="transactionValue")
    private Currency transactionValue = null;

    public ProductAdsPaymentEvent postedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
    }

    public ProductAdsPaymentEvent transactionType(String transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @Schema(description="Indicates if the transaction is for a charge or a refund.  Possible values:  * charge - Charge  * refund - Refund")
    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public ProductAdsPaymentEvent invoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
        return this;
    }

    @Schema(description="Identifier for the invoice that the transaction appears in.")
    public String getInvoiceId() {
        return this.invoiceId;
    }

    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    public ProductAdsPaymentEvent baseValue(Currency baseValue) {
        this.baseValue = baseValue;
        return this;
    }

    @Schema(description="")
    public Currency getBaseValue() {
        return this.baseValue;
    }

    public void setBaseValue(Currency baseValue) {
        this.baseValue = baseValue;
    }

    public ProductAdsPaymentEvent taxValue(Currency taxValue) {
        this.taxValue = taxValue;
        return this;
    }

    @Schema(description="")
    public Currency getTaxValue() {
        return this.taxValue;
    }

    public void setTaxValue(Currency taxValue) {
        this.taxValue = taxValue;
    }

    public ProductAdsPaymentEvent transactionValue(Currency transactionValue) {
        this.transactionValue = transactionValue;
        return this;
    }

    @Schema(description="")
    public Currency getTransactionValue() {
        return this.transactionValue;
    }

    public void setTransactionValue(Currency transactionValue) {
        this.transactionValue = transactionValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductAdsPaymentEvent productAdsPaymentEvent = (ProductAdsPaymentEvent)o;
        return Objects.equals(this.postedDate, productAdsPaymentEvent.postedDate) && Objects.equals(this.transactionType, productAdsPaymentEvent.transactionType) && Objects.equals(this.invoiceId, productAdsPaymentEvent.invoiceId) && Objects.equals(this.baseValue, productAdsPaymentEvent.baseValue) && Objects.equals(this.taxValue, productAdsPaymentEvent.taxValue) && Objects.equals(this.transactionValue, productAdsPaymentEvent.transactionValue);
    }

    public int hashCode() {
        return Objects.hash(this.postedDate, this.transactionType, this.invoiceId, this.baseValue, this.taxValue, this.transactionValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductAdsPaymentEvent {\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    transactionType: ").append(this.toIndentedString(this.transactionType)).append("\n");
        sb.append("    invoiceId: ").append(this.toIndentedString(this.invoiceId)).append("\n");
        sb.append("    baseValue: ").append(this.toIndentedString(this.baseValue)).append("\n");
        sb.append("    taxValue: ").append(this.toIndentedString(this.taxValue)).append("\n");
        sb.append("    transactionValue: ").append(this.toIndentedString(this.transactionValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

