/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.finances.v0.FeeComponentList;

@Schema(description="A fee event related to Amazon Imaging services.")
public class ImagingServicesFeeEvent {
    @SerializedName(value="ImagingRequestBillingItemID")
    private String imagingRequestBillingItemID = null;
    @SerializedName(value="ASIN")
    private String ASIN = null;
    @SerializedName(value="PostedDate")
    private OffsetDateTime postedDate = null;
    @SerializedName(value="FeeList")
    private FeeComponentList feeList = null;

    public ImagingServicesFeeEvent imagingRequestBillingItemID(String imagingRequestBillingItemID) {
        this.imagingRequestBillingItemID = imagingRequestBillingItemID;
        return this;
    }

    @Schema(description="The identifier for the imaging services request.")
    public String getImagingRequestBillingItemID() {
        return this.imagingRequestBillingItemID;
    }

    public void setImagingRequestBillingItemID(String imagingRequestBillingItemID) {
        this.imagingRequestBillingItemID = imagingRequestBillingItemID;
    }

    public ImagingServicesFeeEvent ASIN(String ASIN) {
        this.ASIN = ASIN;
        return this;
    }

    @Schema(description="The Amazon Standard Identification Number (ASIN) of the item for which the imaging service was requested.")
    public String getASIN() {
        return this.ASIN;
    }

    public void setASIN(String ASIN) {
        this.ASIN = ASIN;
    }

    public ImagingServicesFeeEvent postedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
    }

    public ImagingServicesFeeEvent feeList(FeeComponentList feeList) {
        this.feeList = feeList;
        return this;
    }

    @Schema(description="")
    public FeeComponentList getFeeList() {
        return this.feeList;
    }

    public void setFeeList(FeeComponentList feeList) {
        this.feeList = feeList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImagingServicesFeeEvent imagingServicesFeeEvent = (ImagingServicesFeeEvent)o;
        return Objects.equals(this.imagingRequestBillingItemID, imagingServicesFeeEvent.imagingRequestBillingItemID) && Objects.equals(this.ASIN, imagingServicesFeeEvent.ASIN) && Objects.equals(this.postedDate, imagingServicesFeeEvent.postedDate) && Objects.equals(this.feeList, imagingServicesFeeEvent.feeList);
    }

    public int hashCode() {
        return Objects.hash(this.imagingRequestBillingItemID, this.ASIN, this.postedDate, this.feeList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImagingServicesFeeEvent {\n");
        sb.append("    imagingRequestBillingItemID: ").append(this.toIndentedString(this.imagingRequestBillingItemID)).append("\n");
        sb.append("    ASIN: ").append(this.toIndentedString(this.ASIN)).append("\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    feeList: ").append(this.toIndentedString(this.feeList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

