/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.finances.v0.Currency;

@Schema(description="Failed ad hoc disbursement event list.")
public class FailedAdhocDisbursementEvent {
    @SerializedName(value="FundsTransfersType")
    private String fundsTransfersType = null;
    @SerializedName(value="TransferId")
    private String transferId = null;
    @SerializedName(value="DisbursementId")
    private String disbursementId = null;
    @SerializedName(value="PaymentDisbursementType")
    private String paymentDisbursementType = null;
    @SerializedName(value="Status")
    private String status = null;
    @SerializedName(value="TransferAmount")
    private Currency transferAmount = null;
    @SerializedName(value="PostedDate")
    private OffsetDateTime postedDate = null;

    public FailedAdhocDisbursementEvent fundsTransfersType(String fundsTransfersType) {
        this.fundsTransfersType = fundsTransfersType;
        return this;
    }

    @Schema(description="The type of fund transfer.   Example \"Refund\"")
    public String getFundsTransfersType() {
        return this.fundsTransfersType;
    }

    public void setFundsTransfersType(String fundsTransfersType) {
        this.fundsTransfersType = fundsTransfersType;
    }

    public FailedAdhocDisbursementEvent transferId(String transferId) {
        this.transferId = transferId;
        return this;
    }

    @Schema(description="The transfer identifier.")
    public String getTransferId() {
        return this.transferId;
    }

    public void setTransferId(String transferId) {
        this.transferId = transferId;
    }

    public FailedAdhocDisbursementEvent disbursementId(String disbursementId) {
        this.disbursementId = disbursementId;
        return this;
    }

    @Schema(description="The disbursement identifier.")
    public String getDisbursementId() {
        return this.disbursementId;
    }

    public void setDisbursementId(String disbursementId) {
        this.disbursementId = disbursementId;
    }

    public FailedAdhocDisbursementEvent paymentDisbursementType(String paymentDisbursementType) {
        this.paymentDisbursementType = paymentDisbursementType;
        return this;
    }

    @Schema(description="The type of payment for disbursement.   Example `CREDIT_CARD`")
    public String getPaymentDisbursementType() {
        return this.paymentDisbursementType;
    }

    public void setPaymentDisbursementType(String paymentDisbursementType) {
        this.paymentDisbursementType = paymentDisbursementType;
    }

    public FailedAdhocDisbursementEvent status(String status) {
        this.status = status;
        return this;
    }

    @Schema(description="The status of the failed `AdhocDisbursement`.   Example `HARD_DECLINED`")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public FailedAdhocDisbursementEvent transferAmount(Currency transferAmount) {
        this.transferAmount = transferAmount;
        return this;
    }

    @Schema(description="")
    public Currency getTransferAmount() {
        return this.transferAmount;
    }

    public void setTransferAmount(Currency transferAmount) {
        this.transferAmount = transferAmount;
    }

    public FailedAdhocDisbursementEvent postedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FailedAdhocDisbursementEvent failedAdhocDisbursementEvent = (FailedAdhocDisbursementEvent)o;
        return Objects.equals(this.fundsTransfersType, failedAdhocDisbursementEvent.fundsTransfersType) && Objects.equals(this.transferId, failedAdhocDisbursementEvent.transferId) && Objects.equals(this.disbursementId, failedAdhocDisbursementEvent.disbursementId) && Objects.equals(this.paymentDisbursementType, failedAdhocDisbursementEvent.paymentDisbursementType) && Objects.equals(this.status, failedAdhocDisbursementEvent.status) && Objects.equals(this.transferAmount, failedAdhocDisbursementEvent.transferAmount) && Objects.equals(this.postedDate, failedAdhocDisbursementEvent.postedDate);
    }

    public int hashCode() {
        return Objects.hash(this.fundsTransfersType, this.transferId, this.disbursementId, this.paymentDisbursementType, this.status, this.transferAmount, this.postedDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FailedAdhocDisbursementEvent {\n");
        sb.append("    fundsTransfersType: ").append(this.toIndentedString(this.fundsTransfersType)).append("\n");
        sb.append("    transferId: ").append(this.toIndentedString(this.transferId)).append("\n");
        sb.append("    disbursementId: ").append(this.toIndentedString(this.disbursementId)).append("\n");
        sb.append("    paymentDisbursementType: ").append(this.toIndentedString(this.paymentDisbursementType)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    transferAmount: ").append(this.toIndentedString(this.transferAmount)).append("\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

