/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.finances.v0.Currency;

@Schema(description="A payment event for Fulfillment by Amazon (FBA) inventory liquidation. This event is used only in the US marketplace.")
public class FBALiquidationEvent {
    @SerializedName(value="PostedDate")
    private OffsetDateTime postedDate = null;
    @SerializedName(value="OriginalRemovalOrderId")
    private String originalRemovalOrderId = null;
    @SerializedName(value="LiquidationProceedsAmount")
    private Currency liquidationProceedsAmount = null;
    @SerializedName(value="LiquidationFeeAmount")
    private Currency liquidationFeeAmount = null;

    public FBALiquidationEvent postedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
    }

    public FBALiquidationEvent originalRemovalOrderId(String originalRemovalOrderId) {
        this.originalRemovalOrderId = originalRemovalOrderId;
        return this;
    }

    @Schema(description="The identifier for the original removal order.")
    public String getOriginalRemovalOrderId() {
        return this.originalRemovalOrderId;
    }

    public void setOriginalRemovalOrderId(String originalRemovalOrderId) {
        this.originalRemovalOrderId = originalRemovalOrderId;
    }

    public FBALiquidationEvent liquidationProceedsAmount(Currency liquidationProceedsAmount) {
        this.liquidationProceedsAmount = liquidationProceedsAmount;
        return this;
    }

    @Schema(description="")
    public Currency getLiquidationProceedsAmount() {
        return this.liquidationProceedsAmount;
    }

    public void setLiquidationProceedsAmount(Currency liquidationProceedsAmount) {
        this.liquidationProceedsAmount = liquidationProceedsAmount;
    }

    public FBALiquidationEvent liquidationFeeAmount(Currency liquidationFeeAmount) {
        this.liquidationFeeAmount = liquidationFeeAmount;
        return this;
    }

    @Schema(description="")
    public Currency getLiquidationFeeAmount() {
        return this.liquidationFeeAmount;
    }

    public void setLiquidationFeeAmount(Currency liquidationFeeAmount) {
        this.liquidationFeeAmount = liquidationFeeAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FBALiquidationEvent fbALiquidationEvent = (FBALiquidationEvent)o;
        return Objects.equals(this.postedDate, fbALiquidationEvent.postedDate) && Objects.equals(this.originalRemovalOrderId, fbALiquidationEvent.originalRemovalOrderId) && Objects.equals(this.liquidationProceedsAmount, fbALiquidationEvent.liquidationProceedsAmount) && Objects.equals(this.liquidationFeeAmount, fbALiquidationEvent.liquidationFeeAmount);
    }

    public int hashCode() {
        return Objects.hash(this.postedDate, this.originalRemovalOrderId, this.liquidationProceedsAmount, this.liquidationFeeAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FBALiquidationEvent {\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    originalRemovalOrderId: ").append(this.toIndentedString(this.originalRemovalOrderId)).append("\n");
        sb.append("    liquidationProceedsAmount: ").append(this.toIndentedString(this.liquidationProceedsAmount)).append("\n");
        sb.append("    liquidationFeeAmount: ").append(this.toIndentedString(this.liquidationFeeAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

