/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.finances.v0.Currency;

@Schema(description="A payment made directly to a seller.")
public class DirectPayment {
    @SerializedName(value="DirectPaymentType")
    private String directPaymentType = null;
    @SerializedName(value="DirectPaymentAmount")
    private Currency directPaymentAmount = null;

    public DirectPayment directPaymentType(String directPaymentType) {
        this.directPaymentType = directPaymentType;
        return this;
    }

    @Schema(description="The type of payment.  Possible values:  * StoredValueCardRevenue - The amount that is deducted from the seller's account because the seller received money through a stored value card.  * StoredValueCardRefund - The amount that Amazon returns to the seller if the order that is bought using a stored value card is refunded.  * PrivateLabelCreditCardRevenue - The amount that is deducted from the seller's account because the seller received money through a private label credit card offered by Amazon.  * PrivateLabelCreditCardRefund - The amount that Amazon returns to the seller if the order that is bought using a private label credit card offered by Amazon is refunded.  * CollectOnDeliveryRevenue - The COD amount that the seller collected directly from the buyer.  * CollectOnDeliveryRefund - The amount that Amazon refunds to the buyer if an order paid for by COD is refunded.")
    public String getDirectPaymentType() {
        return this.directPaymentType;
    }

    public void setDirectPaymentType(String directPaymentType) {
        this.directPaymentType = directPaymentType;
    }

    public DirectPayment directPaymentAmount(Currency directPaymentAmount) {
        this.directPaymentAmount = directPaymentAmount;
        return this;
    }

    @Schema(description="")
    public Currency getDirectPaymentAmount() {
        return this.directPaymentAmount;
    }

    public void setDirectPaymentAmount(Currency directPaymentAmount) {
        this.directPaymentAmount = directPaymentAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectPayment directPayment = (DirectPayment)o;
        return Objects.equals(this.directPaymentType, directPayment.directPaymentType) && Objects.equals(this.directPaymentAmount, directPayment.directPaymentAmount);
    }

    public int hashCode() {
        return Objects.hash(this.directPaymentType, this.directPaymentAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DirectPayment {\n");
        sb.append("    directPaymentType: ").append(this.toIndentedString(this.directPaymentType)).append("\n");
        sb.append("    directPaymentAmount: ").append(this.toIndentedString(this.directPaymentAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

