/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.finances.v0.Currency;

@Schema(description="An event related to a capacity reservation billing charge.")
public class CapacityReservationBillingEvent {
    @SerializedName(value="TransactionType")
    private String transactionType = null;
    @SerializedName(value="PostedDate")
    private OffsetDateTime postedDate = null;
    @SerializedName(value="Description")
    private String description = null;
    @SerializedName(value="TransactionAmount")
    private Currency transactionAmount = null;

    public CapacityReservationBillingEvent transactionType(String transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @Schema(description="Indicates the type of transaction. For example, FBA Inventory Fee")
    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public CapacityReservationBillingEvent postedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
    }

    public CapacityReservationBillingEvent description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A short description of the capacity reservation billing event.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CapacityReservationBillingEvent transactionAmount(Currency transactionAmount) {
        this.transactionAmount = transactionAmount;
        return this;
    }

    @Schema(description="")
    public Currency getTransactionAmount() {
        return this.transactionAmount;
    }

    public void setTransactionAmount(Currency transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapacityReservationBillingEvent capacityReservationBillingEvent = (CapacityReservationBillingEvent)o;
        return Objects.equals(this.transactionType, capacityReservationBillingEvent.transactionType) && Objects.equals(this.postedDate, capacityReservationBillingEvent.postedDate) && Objects.equals(this.description, capacityReservationBillingEvent.description) && Objects.equals(this.transactionAmount, capacityReservationBillingEvent.transactionAmount);
    }

    public int hashCode() {
        return Objects.hash(this.transactionType, this.postedDate, this.description, this.transactionAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CapacityReservationBillingEvent {\n");
        sb.append("    transactionType: ").append(this.toIndentedString(this.transactionType)).append("\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    transactionAmount: ").append(this.toIndentedString(this.transactionAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

