/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.feeds.v2021_06_30;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.feeds.v2021_06_30.FeedOptions;

@Schema(description="Information required to create the feed.")
public class CreateFeedSpecification {
    @SerializedName(value="feedType")
    private String feedType = null;
    @SerializedName(value="marketplaceIds")
    private List<String> marketplaceIds = new ArrayList<String>();
    @SerializedName(value="inputFeedDocumentId")
    private String inputFeedDocumentId = null;
    @SerializedName(value="feedOptions")
    private FeedOptions feedOptions = null;

    public CreateFeedSpecification feedType(String feedType) {
        this.feedType = feedType;
        return this;
    }

    @Schema(required=true, description="The feed type.")
    public String getFeedType() {
        return this.feedType;
    }

    public void setFeedType(String feedType) {
        this.feedType = feedType;
    }

    public CreateFeedSpecification marketplaceIds(List<String> marketplaceIds) {
        this.marketplaceIds = marketplaceIds;
        return this;
    }

    public CreateFeedSpecification addMarketplaceIdsItem(String marketplaceIdsItem) {
        this.marketplaceIds.add(marketplaceIdsItem);
        return this;
    }

    @Schema(required=true, description="A list of identifiers for marketplaces that you want the feed to be applied to.")
    public List<String> getMarketplaceIds() {
        return this.marketplaceIds;
    }

    public void setMarketplaceIds(List<String> marketplaceIds) {
        this.marketplaceIds = marketplaceIds;
    }

    public CreateFeedSpecification inputFeedDocumentId(String inputFeedDocumentId) {
        this.inputFeedDocumentId = inputFeedDocumentId;
        return this;
    }

    @Schema(required=true, description="The document identifier returned by the createFeedDocument operation. Upload the feed document contents before calling the createFeed operation.")
    public String getInputFeedDocumentId() {
        return this.inputFeedDocumentId;
    }

    public void setInputFeedDocumentId(String inputFeedDocumentId) {
        this.inputFeedDocumentId = inputFeedDocumentId;
    }

    public CreateFeedSpecification feedOptions(FeedOptions feedOptions) {
        this.feedOptions = feedOptions;
        return this;
    }

    @Schema(description="")
    public FeedOptions getFeedOptions() {
        return this.feedOptions;
    }

    public void setFeedOptions(FeedOptions feedOptions) {
        this.feedOptions = feedOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateFeedSpecification createFeedSpecification = (CreateFeedSpecification)o;
        return Objects.equals(this.feedType, createFeedSpecification.feedType) && Objects.equals(this.marketplaceIds, createFeedSpecification.marketplaceIds) && Objects.equals(this.inputFeedDocumentId, createFeedSpecification.inputFeedDocumentId) && Objects.equals(this.feedOptions, createFeedSpecification.feedOptions);
    }

    public int hashCode() {
        return Objects.hash(this.feedType, this.marketplaceIds, this.inputFeedDocumentId, this.feedOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateFeedSpecification {\n");
        sb.append("    feedType: ").append(this.toIndentedString(this.feedType)).append("\n");
        sb.append("    marketplaceIds: ").append(this.toIndentedString(this.marketplaceIds)).append("\n");
        sb.append("    inputFeedDocumentId: ").append(this.toIndentedString(this.inputFeedDocumentId)).append("\n");
        sb.append("    feedOptions: ").append(this.toIndentedString(this.feedOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

