/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fba.inventory.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.fba.inventory.v1.ResearchingQuantityEntry;

@Schema(description="The number of misplaced or warehouse damaged units that are actively being confirmed at our fulfillment centers.")
public class ResearchingQuantity {
    @SerializedName(value="totalResearchingQuantity")
    private Integer totalResearchingQuantity = null;
    @SerializedName(value="researchingQuantityBreakdown")
    private List<ResearchingQuantityEntry> researchingQuantityBreakdown = null;

    public ResearchingQuantity totalResearchingQuantity(Integer totalResearchingQuantity) {
        this.totalResearchingQuantity = totalResearchingQuantity;
        return this;
    }

    @Schema(description="The total number of units currently being researched in Amazon's fulfillment network.")
    public Integer getTotalResearchingQuantity() {
        return this.totalResearchingQuantity;
    }

    public void setTotalResearchingQuantity(Integer totalResearchingQuantity) {
        this.totalResearchingQuantity = totalResearchingQuantity;
    }

    public ResearchingQuantity researchingQuantityBreakdown(List<ResearchingQuantityEntry> researchingQuantityBreakdown) {
        this.researchingQuantityBreakdown = researchingQuantityBreakdown;
        return this;
    }

    public ResearchingQuantity addResearchingQuantityBreakdownItem(ResearchingQuantityEntry researchingQuantityBreakdownItem) {
        if (this.researchingQuantityBreakdown == null) {
            this.researchingQuantityBreakdown = new ArrayList<ResearchingQuantityEntry>();
        }
        this.researchingQuantityBreakdown.add(researchingQuantityBreakdownItem);
        return this;
    }

    @Schema(description="A list of quantity details for items currently being researched.")
    public List<ResearchingQuantityEntry> getResearchingQuantityBreakdown() {
        return this.researchingQuantityBreakdown;
    }

    public void setResearchingQuantityBreakdown(List<ResearchingQuantityEntry> researchingQuantityBreakdown) {
        this.researchingQuantityBreakdown = researchingQuantityBreakdown;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResearchingQuantity researchingQuantity = (ResearchingQuantity)o;
        return Objects.equals(this.totalResearchingQuantity, researchingQuantity.totalResearchingQuantity) && Objects.equals(this.researchingQuantityBreakdown, researchingQuantity.researchingQuantityBreakdown);
    }

    public int hashCode() {
        return Objects.hash(this.totalResearchingQuantity, this.researchingQuantityBreakdown);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResearchingQuantity {\n");
        sb.append("    totalResearchingQuantity: ").append(this.toIndentedString(this.totalResearchingQuantity)).append("\n");
        sb.append("    researchingQuantityBreakdown: ").append(this.toIndentedString(this.researchingQuantityBreakdown)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

