/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fba.inventory.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.fba.inventory.v1.InventoryDetails;

@Schema(description="Inventory summary for a specific item.")
public class InventorySummary {
    @SerializedName(value="asin")
    private String asin = null;
    @SerializedName(value="fnSku")
    private String fnSku = null;
    @SerializedName(value="sellerSku")
    private String sellerSku = null;
    @SerializedName(value="condition")
    private String condition = null;
    @SerializedName(value="inventoryDetails")
    private InventoryDetails inventoryDetails = null;
    @SerializedName(value="lastUpdatedTime")
    private OffsetDateTime lastUpdatedTime = null;
    @SerializedName(value="productName")
    private String productName = null;
    @SerializedName(value="totalQuantity")
    private Integer totalQuantity = null;
    @SerializedName(value="stores")
    private List<String> stores = null;

    public InventorySummary asin(String asin) {
        this.asin = asin;
        return this;
    }

    @Schema(description="The Amazon Standard Identification Number (ASIN) of an item.")
    public String getAsin() {
        return this.asin;
    }

    public void setAsin(String asin) {
        this.asin = asin;
    }

    public InventorySummary fnSku(String fnSku) {
        this.fnSku = fnSku;
        return this;
    }

    @Schema(description="Amazon's fulfillment network SKU identifier.")
    public String getFnSku() {
        return this.fnSku;
    }

    public void setFnSku(String fnSku) {
        this.fnSku = fnSku;
    }

    public InventorySummary sellerSku(String sellerSku) {
        this.sellerSku = sellerSku;
        return this;
    }

    @Schema(description="The seller SKU of the item.")
    public String getSellerSku() {
        return this.sellerSku;
    }

    public void setSellerSku(String sellerSku) {
        this.sellerSku = sellerSku;
    }

    public InventorySummary condition(String condition) {
        this.condition = condition;
        return this;
    }

    @Schema(description="The condition of the item as described by the seller (for example, New Item).")
    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public InventorySummary inventoryDetails(InventoryDetails inventoryDetails) {
        this.inventoryDetails = inventoryDetails;
        return this;
    }

    @Schema(description="")
    public InventoryDetails getInventoryDetails() {
        return this.inventoryDetails;
    }

    public void setInventoryDetails(InventoryDetails inventoryDetails) {
        this.inventoryDetails = inventoryDetails;
    }

    public InventorySummary lastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
        return this;
    }

    @Schema(description="The date and time that any quantity was last updated.")
    public OffsetDateTime getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void setLastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public InventorySummary productName(String productName) {
        this.productName = productName;
        return this;
    }

    @Schema(description="The localized language product title of the item within the specific marketplace.")
    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public InventorySummary totalQuantity(Integer totalQuantity) {
        this.totalQuantity = totalQuantity;
        return this;
    }

    @Schema(description="The total number of units in an inbound shipment or in Amazon fulfillment centers.")
    public Integer getTotalQuantity() {
        return this.totalQuantity;
    }

    public void setTotalQuantity(Integer totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public InventorySummary stores(List<String> stores) {
        this.stores = stores;
        return this;
    }

    public InventorySummary addStoresItem(String storesItem) {
        if (this.stores == null) {
            this.stores = new ArrayList<String>();
        }
        this.stores.add(storesItem);
        return this;
    }

    @Schema(description="A list of seller-enrolled stores that apply to this seller SKU.")
    public List<String> getStores() {
        return this.stores;
    }

    public void setStores(List<String> stores) {
        this.stores = stores;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventorySummary inventorySummary = (InventorySummary)o;
        return Objects.equals(this.asin, inventorySummary.asin) && Objects.equals(this.fnSku, inventorySummary.fnSku) && Objects.equals(this.sellerSku, inventorySummary.sellerSku) && Objects.equals(this.condition, inventorySummary.condition) && Objects.equals(this.inventoryDetails, inventorySummary.inventoryDetails) && Objects.equals(this.lastUpdatedTime, inventorySummary.lastUpdatedTime) && Objects.equals(this.productName, inventorySummary.productName) && Objects.equals(this.totalQuantity, inventorySummary.totalQuantity) && Objects.equals(this.stores, inventorySummary.stores);
    }

    public int hashCode() {
        return Objects.hash(this.asin, this.fnSku, this.sellerSku, this.condition, this.inventoryDetails, this.lastUpdatedTime, this.productName, this.totalQuantity, this.stores);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InventorySummary {\n");
        sb.append("    asin: ").append(this.toIndentedString(this.asin)).append("\n");
        sb.append("    fnSku: ").append(this.toIndentedString(this.fnSku)).append("\n");
        sb.append("    sellerSku: ").append(this.toIndentedString(this.sellerSku)).append("\n");
        sb.append("    condition: ").append(this.toIndentedString(this.condition)).append("\n");
        sb.append("    inventoryDetails: ").append(this.toIndentedString(this.inventoryDetails)).append("\n");
        sb.append("    lastUpdatedTime: ").append(this.toIndentedString(this.lastUpdatedTime)).append("\n");
        sb.append("    productName: ").append(this.toIndentedString(this.productName)).append("\n");
        sb.append("    totalQuantity: ").append(this.toIndentedString(this.totalQuantity)).append("\n");
        sb.append("    stores: ").append(this.toIndentedString(this.stores)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

