/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.datakiosk.v2023_11_15;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.datakiosk.v2023_11_15.QueryPagination;

@Schema(description="Detailed information about the query.")
public class Query {
    @SerializedName(value="queryId")
    private String queryId = null;
    @SerializedName(value="query")
    private String query = null;
    @SerializedName(value="createdTime")
    private OffsetDateTime createdTime = null;
    @SerializedName(value="processingStatus")
    private ProcessingStatusEnum processingStatus = null;
    @SerializedName(value="processingStartTime")
    private OffsetDateTime processingStartTime = null;
    @SerializedName(value="processingEndTime")
    private OffsetDateTime processingEndTime = null;
    @SerializedName(value="dataDocumentId")
    private String dataDocumentId = null;
    @SerializedName(value="errorDocumentId")
    private String errorDocumentId = null;
    @SerializedName(value="pagination")
    private QueryPagination pagination = null;

    public Query queryId(String queryId) {
        this.queryId = queryId;
        return this;
    }

    @Schema(required=true, description="The query identifier. This identifier is unique only in combination with a selling partner account ID.")
    public String getQueryId() {
        return this.queryId;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public Query query(String query) {
        this.query = query;
        return this;
    }

    @Schema(required=true, description="The submitted query.")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Query createdTime(OffsetDateTime createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    @Schema(required=true, description="The date and time when the query was created, in ISO 8601 date time format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(OffsetDateTime createdTime) {
        this.createdTime = createdTime;
    }

    public Query processingStatus(ProcessingStatusEnum processingStatus) {
        this.processingStatus = processingStatus;
        return this;
    }

    @Schema(required=true, description="The processing status of the query.")
    public ProcessingStatusEnum getProcessingStatus() {
        return this.processingStatus;
    }

    public void setProcessingStatus(ProcessingStatusEnum processingStatus) {
        this.processingStatus = processingStatus;
    }

    public Query processingStartTime(OffsetDateTime processingStartTime) {
        this.processingStartTime = processingStartTime;
        return this;
    }

    @Schema(description="The date and time when the query processing started, in ISO 8601 date time format.")
    public OffsetDateTime getProcessingStartTime() {
        return this.processingStartTime;
    }

    public void setProcessingStartTime(OffsetDateTime processingStartTime) {
        this.processingStartTime = processingStartTime;
    }

    public Query processingEndTime(OffsetDateTime processingEndTime) {
        this.processingEndTime = processingEndTime;
        return this;
    }

    @Schema(description="The date and time when the query processing completed, in ISO 8601 date time format.")
    public OffsetDateTime getProcessingEndTime() {
        return this.processingEndTime;
    }

    public void setProcessingEndTime(OffsetDateTime processingEndTime) {
        this.processingEndTime = processingEndTime;
    }

    public Query dataDocumentId(String dataDocumentId) {
        this.dataDocumentId = dataDocumentId;
        return this;
    }

    @Schema(description="The data document identifier. This identifier is only present when there is data available as a result of the query. This identifier is unique only in combination with a selling partner account ID. Pass this identifier into the `getDocument` operation to get the information required to retrieve the data document's contents.")
    public String getDataDocumentId() {
        return this.dataDocumentId;
    }

    public void setDataDocumentId(String dataDocumentId) {
        this.dataDocumentId = dataDocumentId;
    }

    public Query errorDocumentId(String errorDocumentId) {
        this.errorDocumentId = errorDocumentId;
        return this;
    }

    @Schema(description="The error document identifier. This identifier is only present when an error occurs during query processing. This identifier is unique only in combination with a selling partner account ID. Pass this identifier into the `getDocument` operation to get the information required to retrieve the error document's contents.")
    public String getErrorDocumentId() {
        return this.errorDocumentId;
    }

    public void setErrorDocumentId(String errorDocumentId) {
        this.errorDocumentId = errorDocumentId;
    }

    public Query pagination(QueryPagination pagination) {
        this.pagination = pagination;
        return this;
    }

    @Schema(description="")
    public QueryPagination getPagination() {
        return this.pagination;
    }

    public void setPagination(QueryPagination pagination) {
        this.pagination = pagination;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query = (Query)o;
        return Objects.equals(this.queryId, query.queryId) && Objects.equals(this.query, query.query) && Objects.equals(this.createdTime, query.createdTime) && Objects.equals((Object)this.processingStatus, (Object)query.processingStatus) && Objects.equals(this.processingStartTime, query.processingStartTime) && Objects.equals(this.processingEndTime, query.processingEndTime) && Objects.equals(this.dataDocumentId, query.dataDocumentId) && Objects.equals(this.errorDocumentId, query.errorDocumentId) && Objects.equals(this.pagination, query.pagination);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.queryId, this.query, this.createdTime, this.processingStatus, this.processingStartTime, this.processingEndTime, this.dataDocumentId, this.errorDocumentId, this.pagination});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Query {\n");
        sb.append("    queryId: ").append(this.toIndentedString(this.queryId)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    processingStatus: ").append(this.toIndentedString((Object)this.processingStatus)).append("\n");
        sb.append("    processingStartTime: ").append(this.toIndentedString(this.processingStartTime)).append("\n");
        sb.append("    processingEndTime: ").append(this.toIndentedString(this.processingEndTime)).append("\n");
        sb.append("    dataDocumentId: ").append(this.toIndentedString(this.dataDocumentId)).append("\n");
        sb.append("    errorDocumentId: ").append(this.toIndentedString(this.errorDocumentId)).append("\n");
        sb.append("    pagination: ").append(this.toIndentedString(this.pagination)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ProcessingStatusEnum {
        CANCELLED("CANCELLED"),
        DONE("DONE"),
        FATAL("FATAL"),
        IN_PROGRESS("IN_PROGRESS"),
        IN_QUEUE("IN_QUEUE");

        private String value;

        private ProcessingStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ProcessingStatusEnum fromValue(String input) {
            for (ProcessingStatusEnum b : ProcessingStatusEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ProcessingStatusEnum> {
            public void write(JsonWriter jsonWriter, ProcessingStatusEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ProcessingStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ProcessingStatusEnum.fromValue(value);
            }
        }
    }
}

