/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.customerfeedback.v2024_06_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.customerfeedback.v2024_06_01.DateRange;
import software.amazon.spapi.models.customerfeedback.v2024_06_01.ItemReviewTopics;

@Schema(description="The response for the `getItemReviewTopics` operation.")
public class ItemReviewTopicsResponse {
    @SerializedName(value="asin")
    private String asin = null;
    @SerializedName(value="itemName")
    private String itemName = null;
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="countryCode")
    private String countryCode = null;
    @SerializedName(value="dateRange")
    private DateRange dateRange = null;
    @SerializedName(value="topics")
    private ItemReviewTopics topics = null;

    public ItemReviewTopicsResponse asin(String asin) {
        this.asin = asin;
        return this;
    }

    @Schema(required=true, description="The requested ASIN. The Amazon Standard Identification Number (ASIN) is the unique identifier of a product within a marketplace.")
    public String getAsin() {
        return this.asin;
    }

    public void setAsin(String asin) {
        this.asin = asin;
    }

    public ItemReviewTopicsResponse itemName(String itemName) {
        this.itemName = itemName;
        return this;
    }

    @Schema(required=true, description="The product title of the requested ASIN.")
    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public ItemReviewTopicsResponse marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(required=true, description="The requested marketplace id.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public ItemReviewTopicsResponse countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Schema(required=true, description="The two digit country code of the requested marketplace id, in ISO 3166-1 alpha-2 format.")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public ItemReviewTopicsResponse dateRange(DateRange dateRange) {
        this.dateRange = dateRange;
        return this;
    }

    @Schema(required=true, description="")
    public DateRange getDateRange() {
        return this.dateRange;
    }

    public void setDateRange(DateRange dateRange) {
        this.dateRange = dateRange;
    }

    public ItemReviewTopicsResponse topics(ItemReviewTopics topics) {
        this.topics = topics;
        return this;
    }

    @Schema(required=true, description="")
    public ItemReviewTopics getTopics() {
        return this.topics;
    }

    public void setTopics(ItemReviewTopics topics) {
        this.topics = topics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemReviewTopicsResponse itemReviewTopicsResponse = (ItemReviewTopicsResponse)o;
        return Objects.equals(this.asin, itemReviewTopicsResponse.asin) && Objects.equals(this.itemName, itemReviewTopicsResponse.itemName) && Objects.equals(this.marketplaceId, itemReviewTopicsResponse.marketplaceId) && Objects.equals(this.countryCode, itemReviewTopicsResponse.countryCode) && Objects.equals(this.dateRange, itemReviewTopicsResponse.dateRange) && Objects.equals(this.topics, itemReviewTopicsResponse.topics);
    }

    public int hashCode() {
        return Objects.hash(this.asin, this.itemName, this.marketplaceId, this.countryCode, this.dateRange, this.topics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemReviewTopicsResponse {\n");
        sb.append("    asin: ").append(this.toIndentedString(this.asin)).append("\n");
        sb.append("    itemName: ").append(this.toIndentedString(this.itemName)).append("\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    dateRange: ").append(this.toIndentedString(this.dateRange)).append("\n");
        sb.append("    topics: ").append(this.toIndentedString(this.topics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

