/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.customerfeedback.v2024_06_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.customerfeedback.v2024_06_01.BrowseNodeReviewTrend;

@Schema(description="The 10 most positive and most negative review topics for all items in a browse node.")
public class BrowseNodeReviewTrends {
    @SerializedName(value="positiveTopics")
    private List<BrowseNodeReviewTrend> positiveTopics = null;
    @SerializedName(value="negativeTopics")
    private List<BrowseNodeReviewTrend> negativeTopics = null;

    public BrowseNodeReviewTrends positiveTopics(List<BrowseNodeReviewTrend> positiveTopics) {
        this.positiveTopics = positiveTopics;
        return this;
    }

    public BrowseNodeReviewTrends addPositiveTopicsItem(BrowseNodeReviewTrend positiveTopicsItem) {
        if (this.positiveTopics == null) {
            this.positiveTopics = new ArrayList<BrowseNodeReviewTrend>();
        }
        this.positiveTopics.add(positiveTopicsItem);
        return this;
    }

    @Schema(description="The trends of the most positive review topics. The percentage of reviews that contain the topic across all products in the requested browse node determine the topic's placement in the list. This value is `null` if there aren't enough positive reviews for the requested browse node.  **Max length:** 10")
    public List<BrowseNodeReviewTrend> getPositiveTopics() {
        return this.positiveTopics;
    }

    public void setPositiveTopics(List<BrowseNodeReviewTrend> positiveTopics) {
        this.positiveTopics = positiveTopics;
    }

    public BrowseNodeReviewTrends negativeTopics(List<BrowseNodeReviewTrend> negativeTopics) {
        this.negativeTopics = negativeTopics;
        return this;
    }

    public BrowseNodeReviewTrends addNegativeTopicsItem(BrowseNodeReviewTrend negativeTopicsItem) {
        if (this.negativeTopics == null) {
            this.negativeTopics = new ArrayList<BrowseNodeReviewTrend>();
        }
        this.negativeTopics.add(negativeTopicsItem);
        return this;
    }

    @Schema(description="The trends of the most negative review topics. The percentage of reviews that contain the topic across all products in the requested browse node determine the topic's placement in the list. This value is `null` if there aren't enough positive reviews for the requested browse node.  **Max length:** 10")
    public List<BrowseNodeReviewTrend> getNegativeTopics() {
        return this.negativeTopics;
    }

    public void setNegativeTopics(List<BrowseNodeReviewTrend> negativeTopics) {
        this.negativeTopics = negativeTopics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrowseNodeReviewTrends browseNodeReviewTrends = (BrowseNodeReviewTrends)o;
        return Objects.equals(this.positiveTopics, browseNodeReviewTrends.positiveTopics) && Objects.equals(this.negativeTopics, browseNodeReviewTrends.negativeTopics);
    }

    public int hashCode() {
        return Objects.hash(this.positiveTopics, this.negativeTopics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BrowseNodeReviewTrends {\n");
        sb.append("    positiveTopics: ").append(this.toIndentedString(this.positiveTopics)).append("\n");
        sb.append("    negativeTopics: ").append(this.toIndentedString(this.negativeTopics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

