/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.customerfeedback.v2024_06_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.customerfeedback.v2024_06_01.BrowseNodeReviewTopic;

@Schema(description="The 10 most positive and most negative review topics for all items in a browse node.")
public class BrowseNodeReviewTopics {
    @SerializedName(value="positiveTopics")
    private List<BrowseNodeReviewTopic> positiveTopics = null;
    @SerializedName(value="negativeTopics")
    private List<BrowseNodeReviewTopic> negativeTopics = null;

    public BrowseNodeReviewTopics positiveTopics(List<BrowseNodeReviewTopic> positiveTopics) {
        this.positiveTopics = positiveTopics;
        return this;
    }

    public BrowseNodeReviewTopics addPositiveTopicsItem(BrowseNodeReviewTopic positiveTopicsItem) {
        if (this.positiveTopics == null) {
            this.positiveTopics = new ArrayList<BrowseNodeReviewTopic>();
        }
        this.positiveTopics.add(positiveTopicsItem);
        return this;
    }

    @Schema(description="A list of the most positive review topics. When the `sortBy` query parameter is set to `MENTIONS`, the number of reviews of items within the requested browse node that mention the topic determine the topic's placement in the list. When `sortBy` is set to `STAR_RATING_IMPACT`, the effect that the topic has on the star rating of items within the requested browse node determine placement in the list. This value is `null` if there are not enough positive reviews for the requested browse node.  **Max length:** 10")
    public List<BrowseNodeReviewTopic> getPositiveTopics() {
        return this.positiveTopics;
    }

    public void setPositiveTopics(List<BrowseNodeReviewTopic> positiveTopics) {
        this.positiveTopics = positiveTopics;
    }

    public BrowseNodeReviewTopics negativeTopics(List<BrowseNodeReviewTopic> negativeTopics) {
        this.negativeTopics = negativeTopics;
        return this;
    }

    public BrowseNodeReviewTopics addNegativeTopicsItem(BrowseNodeReviewTopic negativeTopicsItem) {
        if (this.negativeTopics == null) {
            this.negativeTopics = new ArrayList<BrowseNodeReviewTopic>();
        }
        this.negativeTopics.add(negativeTopicsItem);
        return this;
    }

    @Schema(description="A list of the most negative review topics. When the `sortBy` query parameter is set to `MENTIONS`, the number of reviews of items within the requested browse node that mention the topic determine the topic's placement in the list. When `sortBy` is set to `STAR_RATING_IMPACT`, the effect that the topic has on the star rating of items within the requested browse node determine placement in the list. This value is `null` if there are not enough negative reviews for the requested browse node.  **Max length:** 10")
    public List<BrowseNodeReviewTopic> getNegativeTopics() {
        return this.negativeTopics;
    }

    public void setNegativeTopics(List<BrowseNodeReviewTopic> negativeTopics) {
        this.negativeTopics = negativeTopics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrowseNodeReviewTopics browseNodeReviewTopics = (BrowseNodeReviewTopics)o;
        return Objects.equals(this.positiveTopics, browseNodeReviewTopics.positiveTopics) && Objects.equals(this.negativeTopics, browseNodeReviewTopics.negativeTopics);
    }

    public int hashCode() {
        return Objects.hash(this.positiveTopics, this.negativeTopics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BrowseNodeReviewTopics {\n");
        sb.append("    positiveTopics: ").append(this.toIndentedString(this.positiveTopics)).append("\n");
        sb.append("    negativeTopics: ").append(this.toIndentedString(this.negativeTopics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

