/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.catalogitems.v2022_04_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Pagination occurs when a request produces a response that exceeds the `pageSize`. This means that the response is divided into individual pages. To retrieve the next page or the previous page of results, you must pass the `nextToken` value or the `previousToken` value as the `pageToken` parameter in the next request. There is no `nextToken` in the pagination object on the last page.")
public class Pagination {
    @SerializedName(value="nextToken")
    private String nextToken = null;
    @SerializedName(value="previousToken")
    private String previousToken = null;

    public Pagination nextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    @Schema(description="A token that you can use to retrieve the next page.")
    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public Pagination previousToken(String previousToken) {
        this.previousToken = previousToken;
        return this;
    }

    @Schema(description="A token that you can use to retrieve the previous page.")
    public String getPreviousToken() {
        return this.previousToken;
    }

    public void setPreviousToken(String previousToken) {
        this.previousToken = previousToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pagination pagination = (Pagination)o;
        return Objects.equals(this.nextToken, pagination.nextToken) && Objects.equals(this.previousToken, pagination.previousToken);
    }

    public int hashCode() {
        return Objects.hash(this.nextToken, this.previousToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Pagination {\n");
        sb.append("    nextToken: ").append(this.toIndentedString(this.nextToken)).append("\n");
        sb.append("    previousToken: ").append(this.toIndentedString(this.previousToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

