/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.catalogitems.v2022_04_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="The variation theme is a list of Amazon catalog item attributes that define the variation family.")
public class ItemVariationTheme {
    @SerializedName(value="attributes")
    private List<String> attributes = null;
    @SerializedName(value="theme")
    private String theme = null;

    public ItemVariationTheme attributes(List<String> attributes) {
        this.attributes = attributes;
        return this;
    }

    public ItemVariationTheme addAttributesItem(String attributesItem) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<String>();
        }
        this.attributes.add(attributesItem);
        return this;
    }

    @Schema(description="Names of the Amazon catalog item attributes that are associated with the variation theme.")
    public List<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    public ItemVariationTheme theme(String theme) {
        this.theme = theme;
        return this;
    }

    @Schema(example="COLOR_NAME/STYLE_NAME", description="Variation theme that indicates the combination of Amazon catalog item attributes that define the variation family.")
    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemVariationTheme itemVariationTheme = (ItemVariationTheme)o;
        return Objects.equals(this.attributes, itemVariationTheme.attributes) && Objects.equals(this.theme, itemVariationTheme.theme);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.theme);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemVariationTheme {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    theme: ").append(this.toIndentedString(this.theme)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

