/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.catalogitems.v2022_04_01;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.LocalDate;
import software.amazon.spapi.models.catalogitems.v2022_04_01.ItemBrowseClassification;
import software.amazon.spapi.models.catalogitems.v2022_04_01.ItemContributor;

@Schema(description="Information about an Amazon catalog item for the indicated `marketplaceId`.")
public class ItemSummaryByMarketplace {
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="adultProduct")
    private Boolean adultProduct = null;
    @SerializedName(value="autographed")
    private Boolean autographed = null;
    @SerializedName(value="brand")
    private String brand = null;
    @SerializedName(value="browseClassification")
    private ItemBrowseClassification browseClassification = null;
    @SerializedName(value="color")
    private String color = null;
    @SerializedName(value="contributors")
    private List<ItemContributor> contributors = null;
    @SerializedName(value="itemClassification")
    private ItemClassificationEnum itemClassification = null;
    @SerializedName(value="itemName")
    private String itemName = null;
    @SerializedName(value="manufacturer")
    private String manufacturer = null;
    @SerializedName(value="memorabilia")
    private Boolean memorabilia = null;
    @SerializedName(value="modelNumber")
    private String modelNumber = null;
    @SerializedName(value="packageQuantity")
    private Integer packageQuantity = null;
    @SerializedName(value="partNumber")
    private String partNumber = null;
    @SerializedName(value="releaseDate")
    private LocalDate releaseDate = null;
    @SerializedName(value="size")
    private String size = null;
    @SerializedName(value="style")
    private String style = null;
    @SerializedName(value="tradeInEligible")
    private Boolean tradeInEligible = null;
    @SerializedName(value="websiteDisplayGroup")
    private String websiteDisplayGroup = null;
    @SerializedName(value="websiteDisplayGroupName")
    private String websiteDisplayGroupName = null;

    public ItemSummaryByMarketplace marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(required=true, description="Amazon marketplace identifier. To find the ID for your marketplace, refer to [Marketplace IDs](https://developer-docs.amazon.com/sp-api/docs/marketplace-ids).")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public ItemSummaryByMarketplace adultProduct(Boolean adultProduct) {
        this.adultProduct = adultProduct;
        return this;
    }

    @Schema(description="When `true`, the Amazon catalog item is intended for an adult audience or is sexual in nature.")
    public Boolean isAdultProduct() {
        return this.adultProduct;
    }

    public void setAdultProduct(Boolean adultProduct) {
        this.adultProduct = adultProduct;
    }

    public ItemSummaryByMarketplace autographed(Boolean autographed) {
        this.autographed = autographed;
        return this;
    }

    @Schema(description="When `true`, the Amazon catalog item is autographed.")
    public Boolean isAutographed() {
        return this.autographed;
    }

    public void setAutographed(Boolean autographed) {
        this.autographed = autographed;
    }

    public ItemSummaryByMarketplace brand(String brand) {
        this.brand = brand;
        return this;
    }

    @Schema(description="Name of the brand that is associated with the Amazon catalog item.")
    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public ItemSummaryByMarketplace browseClassification(ItemBrowseClassification browseClassification) {
        this.browseClassification = browseClassification;
        return this;
    }

    @Schema(description="")
    public ItemBrowseClassification getBrowseClassification() {
        return this.browseClassification;
    }

    public void setBrowseClassification(ItemBrowseClassification browseClassification) {
        this.browseClassification = browseClassification;
    }

    public ItemSummaryByMarketplace color(String color) {
        this.color = color;
        return this;
    }

    @Schema(description="The color that is associated with the Amazon catalog item.")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public ItemSummaryByMarketplace contributors(List<ItemContributor> contributors) {
        this.contributors = contributors;
        return this;
    }

    public ItemSummaryByMarketplace addContributorsItem(ItemContributor contributorsItem) {
        if (this.contributors == null) {
            this.contributors = new ArrayList<ItemContributor>();
        }
        this.contributors.add(contributorsItem);
        return this;
    }

    @Schema(description="Individual contributors to the creation of the item, such as the authors or actors.")
    public List<ItemContributor> getContributors() {
        return this.contributors;
    }

    public void setContributors(List<ItemContributor> contributors) {
        this.contributors = contributors;
    }

    public ItemSummaryByMarketplace itemClassification(ItemClassificationEnum itemClassification) {
        this.itemClassification = itemClassification;
        return this;
    }

    @Schema(description="Classification type that is associated with the Amazon catalog item.")
    public ItemClassificationEnum getItemClassification() {
        return this.itemClassification;
    }

    public void setItemClassification(ItemClassificationEnum itemClassification) {
        this.itemClassification = itemClassification;
    }

    public ItemSummaryByMarketplace itemName(String itemName) {
        this.itemName = itemName;
        return this;
    }

    @Schema(description="The name that is associated with the Amazon catalog item.")
    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public ItemSummaryByMarketplace manufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
        return this;
    }

    @Schema(description="The name of the manufacturer that is associated with the Amazon catalog item.")
    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public ItemSummaryByMarketplace memorabilia(Boolean memorabilia) {
        this.memorabilia = memorabilia;
        return this;
    }

    @Schema(description="When true, the item is classified as memorabilia.")
    public Boolean isMemorabilia() {
        return this.memorabilia;
    }

    public void setMemorabilia(Boolean memorabilia) {
        this.memorabilia = memorabilia;
    }

    public ItemSummaryByMarketplace modelNumber(String modelNumber) {
        this.modelNumber = modelNumber;
        return this;
    }

    @Schema(description="The model number that is associated with the Amazon catalog item.")
    public String getModelNumber() {
        return this.modelNumber;
    }

    public void setModelNumber(String modelNumber) {
        this.modelNumber = modelNumber;
    }

    public ItemSummaryByMarketplace packageQuantity(Integer packageQuantity) {
        this.packageQuantity = packageQuantity;
        return this;
    }

    @Schema(description="The quantity of the Amazon catalog item within one package.")
    public Integer getPackageQuantity() {
        return this.packageQuantity;
    }

    public void setPackageQuantity(Integer packageQuantity) {
        this.packageQuantity = packageQuantity;
    }

    public ItemSummaryByMarketplace partNumber(String partNumber) {
        this.partNumber = partNumber;
        return this;
    }

    @Schema(description="The part number that is associated with the Amazon catalog item.")
    public String getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(String partNumber) {
        this.partNumber = partNumber;
    }

    public ItemSummaryByMarketplace releaseDate(LocalDate releaseDate) {
        this.releaseDate = releaseDate;
        return this;
    }

    @Schema(description="The earliest date on which the Amazon catalog item can be shipped to customers.")
    public LocalDate getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(LocalDate releaseDate) {
        this.releaseDate = releaseDate;
    }

    public ItemSummaryByMarketplace size(String size) {
        this.size = size;
        return this;
    }

    @Schema(description="The name of the size of the Amazon catalog item.")
    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public ItemSummaryByMarketplace style(String style) {
        this.style = style;
        return this;
    }

    @Schema(description="The name of the style that is associated with the Amazon catalog item.")
    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public ItemSummaryByMarketplace tradeInEligible(Boolean tradeInEligible) {
        this.tradeInEligible = tradeInEligible;
        return this;
    }

    @Schema(description="When true, the Amazon catalog item is eligible for trade-in.")
    public Boolean isTradeInEligible() {
        return this.tradeInEligible;
    }

    public void setTradeInEligible(Boolean tradeInEligible) {
        this.tradeInEligible = tradeInEligible;
    }

    public ItemSummaryByMarketplace websiteDisplayGroup(String websiteDisplayGroup) {
        this.websiteDisplayGroup = websiteDisplayGroup;
        return this;
    }

    @Schema(description="The identifier of the website display group that is associated with the Amazon catalog item.")
    public String getWebsiteDisplayGroup() {
        return this.websiteDisplayGroup;
    }

    public void setWebsiteDisplayGroup(String websiteDisplayGroup) {
        this.websiteDisplayGroup = websiteDisplayGroup;
    }

    public ItemSummaryByMarketplace websiteDisplayGroupName(String websiteDisplayGroupName) {
        this.websiteDisplayGroupName = websiteDisplayGroupName;
        return this;
    }

    @Schema(description="The display name of the website display group that is associated with the Amazon catalog item.")
    public String getWebsiteDisplayGroupName() {
        return this.websiteDisplayGroupName;
    }

    public void setWebsiteDisplayGroupName(String websiteDisplayGroupName) {
        this.websiteDisplayGroupName = websiteDisplayGroupName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemSummaryByMarketplace itemSummaryByMarketplace = (ItemSummaryByMarketplace)o;
        return Objects.equals(this.marketplaceId, itemSummaryByMarketplace.marketplaceId) && Objects.equals(this.adultProduct, itemSummaryByMarketplace.adultProduct) && Objects.equals(this.autographed, itemSummaryByMarketplace.autographed) && Objects.equals(this.brand, itemSummaryByMarketplace.brand) && Objects.equals(this.browseClassification, itemSummaryByMarketplace.browseClassification) && Objects.equals(this.color, itemSummaryByMarketplace.color) && Objects.equals(this.contributors, itemSummaryByMarketplace.contributors) && Objects.equals((Object)this.itemClassification, (Object)itemSummaryByMarketplace.itemClassification) && Objects.equals(this.itemName, itemSummaryByMarketplace.itemName) && Objects.equals(this.manufacturer, itemSummaryByMarketplace.manufacturer) && Objects.equals(this.memorabilia, itemSummaryByMarketplace.memorabilia) && Objects.equals(this.modelNumber, itemSummaryByMarketplace.modelNumber) && Objects.equals(this.packageQuantity, itemSummaryByMarketplace.packageQuantity) && Objects.equals(this.partNumber, itemSummaryByMarketplace.partNumber) && Objects.equals(this.releaseDate, itemSummaryByMarketplace.releaseDate) && Objects.equals(this.size, itemSummaryByMarketplace.size) && Objects.equals(this.style, itemSummaryByMarketplace.style) && Objects.equals(this.tradeInEligible, itemSummaryByMarketplace.tradeInEligible) && Objects.equals(this.websiteDisplayGroup, itemSummaryByMarketplace.websiteDisplayGroup) && Objects.equals(this.websiteDisplayGroupName, itemSummaryByMarketplace.websiteDisplayGroupName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.marketplaceId, this.adultProduct, this.autographed, this.brand, this.browseClassification, this.color, this.contributors, this.itemClassification, this.itemName, this.manufacturer, this.memorabilia, this.modelNumber, this.packageQuantity, this.partNumber, this.releaseDate, this.size, this.style, this.tradeInEligible, this.websiteDisplayGroup, this.websiteDisplayGroupName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemSummaryByMarketplace {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    adultProduct: ").append(this.toIndentedString(this.adultProduct)).append("\n");
        sb.append("    autographed: ").append(this.toIndentedString(this.autographed)).append("\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    browseClassification: ").append(this.toIndentedString(this.browseClassification)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    contributors: ").append(this.toIndentedString(this.contributors)).append("\n");
        sb.append("    itemClassification: ").append(this.toIndentedString((Object)this.itemClassification)).append("\n");
        sb.append("    itemName: ").append(this.toIndentedString(this.itemName)).append("\n");
        sb.append("    manufacturer: ").append(this.toIndentedString(this.manufacturer)).append("\n");
        sb.append("    memorabilia: ").append(this.toIndentedString(this.memorabilia)).append("\n");
        sb.append("    modelNumber: ").append(this.toIndentedString(this.modelNumber)).append("\n");
        sb.append("    packageQuantity: ").append(this.toIndentedString(this.packageQuantity)).append("\n");
        sb.append("    partNumber: ").append(this.toIndentedString(this.partNumber)).append("\n");
        sb.append("    releaseDate: ").append(this.toIndentedString(this.releaseDate)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("    tradeInEligible: ").append(this.toIndentedString(this.tradeInEligible)).append("\n");
        sb.append("    websiteDisplayGroup: ").append(this.toIndentedString(this.websiteDisplayGroup)).append("\n");
        sb.append("    websiteDisplayGroupName: ").append(this.toIndentedString(this.websiteDisplayGroupName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ItemClassificationEnum {
        BASE_PRODUCT("BASE_PRODUCT"),
        OTHER("OTHER"),
        PRODUCT_BUNDLE("PRODUCT_BUNDLE"),
        VARIATION_PARENT("VARIATION_PARENT");

        private String value;

        private ItemClassificationEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ItemClassificationEnum fromValue(String input) {
            for (ItemClassificationEnum b : ItemClassificationEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ItemClassificationEnum> {
            public void write(JsonWriter jsonWriter, ItemClassificationEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ItemClassificationEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ItemClassificationEnum.fromValue(value);
            }
        }
    }
}

