/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.catalogitems.v2022_04_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.catalogitems.v2022_04_01.ItemClassificationSalesRank;
import software.amazon.spapi.models.catalogitems.v2022_04_01.ItemDisplayGroupSalesRank;

@Schema(description="Sales ranks of an Amazon catalog item, grouped by `marketplaceId`.")
public class ItemSalesRanksByMarketplace {
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="classificationRanks")
    private List<ItemClassificationSalesRank> classificationRanks = null;
    @SerializedName(value="displayGroupRanks")
    private List<ItemDisplayGroupSalesRank> displayGroupRanks = null;

    public ItemSalesRanksByMarketplace marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(required=true, description="Amazon marketplace identifier. To find the ID for your marketplace, refer to [Marketplace IDs](https://developer-docs.amazon.com/sp-api/docs/marketplace-ids).")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public ItemSalesRanksByMarketplace classificationRanks(List<ItemClassificationSalesRank> classificationRanks) {
        this.classificationRanks = classificationRanks;
        return this;
    }

    public ItemSalesRanksByMarketplace addClassificationRanksItem(ItemClassificationSalesRank classificationRanksItem) {
        if (this.classificationRanks == null) {
            this.classificationRanks = new ArrayList<ItemClassificationSalesRank>();
        }
        this.classificationRanks.add(classificationRanksItem);
        return this;
    }

    @Schema(description="Sales ranks of an Amazon catalog item for a `marketplaceId`, grouped by classification.")
    public List<ItemClassificationSalesRank> getClassificationRanks() {
        return this.classificationRanks;
    }

    public void setClassificationRanks(List<ItemClassificationSalesRank> classificationRanks) {
        this.classificationRanks = classificationRanks;
    }

    public ItemSalesRanksByMarketplace displayGroupRanks(List<ItemDisplayGroupSalesRank> displayGroupRanks) {
        this.displayGroupRanks = displayGroupRanks;
        return this;
    }

    public ItemSalesRanksByMarketplace addDisplayGroupRanksItem(ItemDisplayGroupSalesRank displayGroupRanksItem) {
        if (this.displayGroupRanks == null) {
            this.displayGroupRanks = new ArrayList<ItemDisplayGroupSalesRank>();
        }
        this.displayGroupRanks.add(displayGroupRanksItem);
        return this;
    }

    @Schema(description="Sales ranks of an Amazon catalog item for a `marketplaceId`, grouped by website display group.")
    public List<ItemDisplayGroupSalesRank> getDisplayGroupRanks() {
        return this.displayGroupRanks;
    }

    public void setDisplayGroupRanks(List<ItemDisplayGroupSalesRank> displayGroupRanks) {
        this.displayGroupRanks = displayGroupRanks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemSalesRanksByMarketplace itemSalesRanksByMarketplace = (ItemSalesRanksByMarketplace)o;
        return Objects.equals(this.marketplaceId, itemSalesRanksByMarketplace.marketplaceId) && Objects.equals(this.classificationRanks, itemSalesRanksByMarketplace.classificationRanks) && Objects.equals(this.displayGroupRanks, itemSalesRanksByMarketplace.displayGroupRanks);
    }

    public int hashCode() {
        return Objects.hash(this.marketplaceId, this.classificationRanks, this.displayGroupRanks);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemSalesRanksByMarketplace {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    classificationRanks: ").append(this.toIndentedString(this.classificationRanks)).append("\n");
        sb.append("    displayGroupRanks: ").append(this.toIndentedString(this.displayGroupRanks)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

