/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.catalogitems.v2022_04_01;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.catalogitems.v2022_04_01.ItemVariationTheme;

@Schema(description="Relationship details for an Amazon catalog item.")
public class ItemRelationship {
    @SerializedName(value="childAsins")
    private List<String> childAsins = null;
    @SerializedName(value="parentAsins")
    private List<String> parentAsins = null;
    @SerializedName(value="variationTheme")
    private ItemVariationTheme variationTheme = null;
    @SerializedName(value="type")
    private TypeEnum type = null;

    public ItemRelationship childAsins(List<String> childAsins) {
        this.childAsins = childAsins;
        return this;
    }

    public ItemRelationship addChildAsinsItem(String childAsinsItem) {
        if (this.childAsins == null) {
            this.childAsins = new ArrayList<String>();
        }
        this.childAsins.add(childAsinsItem);
        return this;
    }

    @Schema(description="ASINs of the related items that are children of this item.")
    public List<String> getChildAsins() {
        return this.childAsins;
    }

    public void setChildAsins(List<String> childAsins) {
        this.childAsins = childAsins;
    }

    public ItemRelationship parentAsins(List<String> parentAsins) {
        this.parentAsins = parentAsins;
        return this;
    }

    public ItemRelationship addParentAsinsItem(String parentAsinsItem) {
        if (this.parentAsins == null) {
            this.parentAsins = new ArrayList<String>();
        }
        this.parentAsins.add(parentAsinsItem);
        return this;
    }

    @Schema(description="ASINs of the related items that are parents of this item.")
    public List<String> getParentAsins() {
        return this.parentAsins;
    }

    public void setParentAsins(List<String> parentAsins) {
        this.parentAsins = parentAsins;
    }

    public ItemRelationship variationTheme(ItemVariationTheme variationTheme) {
        this.variationTheme = variationTheme;
        return this;
    }

    @Schema(description="")
    public ItemVariationTheme getVariationTheme() {
        return this.variationTheme;
    }

    public void setVariationTheme(ItemVariationTheme variationTheme) {
        this.variationTheme = variationTheme;
    }

    public ItemRelationship type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(example="VARIATION", required=true, description="Type of relationship.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemRelationship itemRelationship = (ItemRelationship)o;
        return Objects.equals(this.childAsins, itemRelationship.childAsins) && Objects.equals(this.parentAsins, itemRelationship.parentAsins) && Objects.equals(this.variationTheme, itemRelationship.variationTheme) && Objects.equals((Object)this.type, (Object)itemRelationship.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.childAsins, this.parentAsins, this.variationTheme, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemRelationship {\n");
        sb.append("    childAsins: ").append(this.toIndentedString(this.childAsins)).append("\n");
        sb.append("    parentAsins: ").append(this.toIndentedString(this.parentAsins)).append("\n");
        sb.append("    variationTheme: ").append(this.toIndentedString(this.variationTheme)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        VARIATION("VARIATION"),
        PACKAGE_HIERARCHY("PACKAGE_HIERARCHY");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String input) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

