/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.catalogitems.v2022_04_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="The identifier that is associated with the item in the Amazon catalog, such as a UPC or EAN identifier.")
public class ItemIdentifier {
    @SerializedName(value="identifierType")
    private String identifierType = null;
    @SerializedName(value="identifier")
    private String identifier = null;

    public ItemIdentifier identifierType(String identifierType) {
        this.identifierType = identifierType;
        return this;
    }

    @Schema(required=true, description="Type of identifier, such as UPC, EAN, or ISBN.")
    public String getIdentifierType() {
        return this.identifierType;
    }

    public void setIdentifierType(String identifierType) {
        this.identifierType = identifierType;
    }

    public ItemIdentifier identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Schema(required=true, description="Identifier of the item.")
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemIdentifier itemIdentifier = (ItemIdentifier)o;
        return Objects.equals(this.identifierType, itemIdentifier.identifierType) && Objects.equals(this.identifier, itemIdentifier.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifierType, this.identifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemIdentifier {\n");
        sb.append("    identifierType: ").append(this.toIndentedString(this.identifierType)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

