/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.catalogitems.v2022_04_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Role of an individual contributor in the creation of an item, such as author or actor.")
public class ItemContributorRole {
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="value")
    private String value = null;

    public ItemContributorRole displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Schema(description="Display name of the role in the requested locale, such as `Author` or `Actor`.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ItemContributorRole value(String value) {
        this.value = value;
        return this;
    }

    @Schema(required=true, description="Role value for the Amazon catalog item, such as `author` or `actor`.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemContributorRole itemContributorRole = (ItemContributorRole)o;
        return Objects.equals(this.displayName, itemContributorRole.displayName) && Objects.equals(this.value, itemContributorRole.value);
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemContributorRole {\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

