/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.awd.v2024_05_09;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.awd.v2024_05_09.DistributionPackageQuantity;
import software.amazon.spapi.models.awd.v2024_05_09.InboundEligibilityStatus;
import software.amazon.spapi.models.awd.v2024_05_09.SkuIneligibilityReason;

@Schema(description="Represents eligibility of one SKU.")
public class SkuEligibility {
    @SerializedName(value="ineligibilityReasons")
    private List<SkuIneligibilityReason> ineligibilityReasons = null;
    @SerializedName(value="packageQuantity")
    private DistributionPackageQuantity packageQuantity = null;
    @SerializedName(value="status")
    private InboundEligibilityStatus status = null;

    public SkuEligibility ineligibilityReasons(List<SkuIneligibilityReason> ineligibilityReasons) {
        this.ineligibilityReasons = ineligibilityReasons;
        return this;
    }

    public SkuEligibility addIneligibilityReasonsItem(SkuIneligibilityReason ineligibilityReasonsItem) {
        if (this.ineligibilityReasons == null) {
            this.ineligibilityReasons = new ArrayList<SkuIneligibilityReason>();
        }
        this.ineligibilityReasons.add(ineligibilityReasonsItem);
        return this;
    }

    @Schema(description="If not eligible, these are list of error codes and descriptions.")
    public List<SkuIneligibilityReason> getIneligibilityReasons() {
        return this.ineligibilityReasons;
    }

    public void setIneligibilityReasons(List<SkuIneligibilityReason> ineligibilityReasons) {
        this.ineligibilityReasons = ineligibilityReasons;
    }

    public SkuEligibility packageQuantity(DistributionPackageQuantity packageQuantity) {
        this.packageQuantity = packageQuantity;
        return this;
    }

    @Schema(required=true, description="")
    public DistributionPackageQuantity getPackageQuantity() {
        return this.packageQuantity;
    }

    public void setPackageQuantity(DistributionPackageQuantity packageQuantity) {
        this.packageQuantity = packageQuantity;
    }

    public SkuEligibility status(InboundEligibilityStatus status) {
        this.status = status;
        return this;
    }

    @Schema(required=true, description="")
    public InboundEligibilityStatus getStatus() {
        return this.status;
    }

    public void setStatus(InboundEligibilityStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SkuEligibility skuEligibility = (SkuEligibility)o;
        return Objects.equals(this.ineligibilityReasons, skuEligibility.ineligibilityReasons) && Objects.equals(this.packageQuantity, skuEligibility.packageQuantity) && Objects.equals((Object)this.status, (Object)skuEligibility.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ineligibilityReasons, this.packageQuantity, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SkuEligibility {\n");
        sb.append("    ineligibilityReasons: ").append(this.toIndentedString(this.ineligibilityReasons)).append("\n");
        sb.append("    packageQuantity: ").append(this.toIndentedString(this.packageQuantity)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

