/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.awd.v2024_05_09;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.awd.v2024_05_09.InboundShipmentSummary;

@Schema(description="A list of inbound shipment summaries filtered by the attributes specified in the request.")
public class ShipmentListing {
    @SerializedName(value="nextToken")
    private String nextToken = null;
    @SerializedName(value="shipments")
    private List<InboundShipmentSummary> shipments = null;

    public ShipmentListing nextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    @Schema(example="SampleToken", description="A token that is used to retrieve the next page of results. The response includes `nextToken` when the number of results exceeds the specified `maxResults` value. To get the next page of results, call the operation with this token and include the same arguments as the call that produced the token. To get a complete list, call this operation until `nextToken` is null. Note that this operation can return empty pages.")
    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ShipmentListing shipments(List<InboundShipmentSummary> shipments) {
        this.shipments = shipments;
        return this;
    }

    public ShipmentListing addShipmentsItem(InboundShipmentSummary shipmentsItem) {
        if (this.shipments == null) {
            this.shipments = new ArrayList<InboundShipmentSummary>();
        }
        this.shipments.add(shipmentsItem);
        return this;
    }

    @Schema(description="List of inbound shipment summaries.")
    public List<InboundShipmentSummary> getShipments() {
        return this.shipments;
    }

    public void setShipments(List<InboundShipmentSummary> shipments) {
        this.shipments = shipments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShipmentListing shipmentListing = (ShipmentListing)o;
        return Objects.equals(this.nextToken, shipmentListing.nextToken) && Objects.equals(this.shipments, shipmentListing.shipments);
    }

    public int hashCode() {
        return Objects.hash(this.nextToken, this.shipments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShipmentListing {\n");
        sb.append("    nextToken: ").append(this.toIndentedString(this.nextToken)).append("\n");
        sb.append("    shipments: ").append(this.toIndentedString(this.shipments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

