/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.awd.v2024_05_09;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.awd.v2024_05_09.PrepDetails;
import software.amazon.spapi.models.awd.v2024_05_09.ProductAttribute;

@Schema(description="Represents a product with the SKU details and the corresponding quantity.")
public class ProductQuantity {
    @SerializedName(value="attributes")
    private List<ProductAttribute> attributes = null;
    @SerializedName(value="quantity")
    private Integer quantity = null;
    @SerializedName(value="sku")
    private String sku = null;
    @SerializedName(value="expiration")
    private OffsetDateTime expiration = null;
    @SerializedName(value="prepDetails")
    private PrepDetails prepDetails = null;

    public ProductQuantity attributes(List<ProductAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    public ProductQuantity addAttributesItem(ProductAttribute attributesItem) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<ProductAttribute>();
        }
        this.attributes.add(attributesItem);
        return this;
    }

    @Schema(example="{\"name\":\"TestAttribute\",\"value\":\"TestAttributeValue\"}", description="Contains attributes for this instance of the product. For example, item color, or other attributes that distinguish the product beyond the SKU. This is metadata for the product and Amazon does not process this data.")
    public List<ProductAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<ProductAttribute> attributes) {
        this.attributes = attributes;
    }

    public ProductQuantity quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Schema(required=true, description="Product quantity.")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public ProductQuantity sku(String sku) {
        this.sku = sku;
        return this;
    }

    @Schema(required=true, description="The seller or merchant SKU.")
    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public ProductQuantity expiration(OffsetDateTime expiration) {
        this.expiration = expiration;
        return this;
    }

    @Schema(description="The expiration date for the SKU. Values are in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date-time format.")
    public OffsetDateTime getExpiration() {
        return this.expiration;
    }

    public void setExpiration(OffsetDateTime expiration) {
        this.expiration = expiration;
    }

    public ProductQuantity prepDetails(PrepDetails prepDetails) {
        this.prepDetails = prepDetails;
        return this;
    }

    @Schema(description="")
    public PrepDetails getPrepDetails() {
        return this.prepDetails;
    }

    public void setPrepDetails(PrepDetails prepDetails) {
        this.prepDetails = prepDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductQuantity productQuantity = (ProductQuantity)o;
        return Objects.equals(this.attributes, productQuantity.attributes) && Objects.equals(this.quantity, productQuantity.quantity) && Objects.equals(this.sku, productQuantity.sku) && Objects.equals(this.expiration, productQuantity.expiration) && Objects.equals(this.prepDetails, productQuantity.prepDetails);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.quantity, this.sku, this.expiration, this.prepDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductQuantity {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    sku: ").append(this.toIndentedString(this.sku)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    prepDetails: ").append(this.toIndentedString(this.prepDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

