/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.awd.v2024_05_09;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.awd.v2024_05_09.InventorySummary;

@Schema(description="AWD inventory payload.")
public class InventoryListing {
    @SerializedName(value="inventory")
    private List<InventorySummary> inventory = new ArrayList<InventorySummary>();
    @SerializedName(value="nextToken")
    private String nextToken = null;

    public InventoryListing inventory(List<InventorySummary> inventory) {
        this.inventory = inventory;
        return this;
    }

    public InventoryListing addInventoryItem(InventorySummary inventoryItem) {
        this.inventory.add(inventoryItem);
        return this;
    }

    @Schema(required=true, description="List of inventory summaries.")
    public List<InventorySummary> getInventory() {
        return this.inventory;
    }

    public void setInventory(List<InventorySummary> inventory) {
        this.inventory = inventory;
    }

    public InventoryListing nextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    @Schema(example="SampleToken", description="A token that is used to retrieve the next page of results. The response includes `nextToken` when the number of results exceeds the specified `maxResults` value. To get the next page of results, call the operation with this token and include the same arguments as the call that produced the token. To get a complete list, call this operation until `nextToken` is null. Note that this operation can return empty pages.")
    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventoryListing inventoryListing = (InventoryListing)o;
        return Objects.equals(this.inventory, inventoryListing.inventory) && Objects.equals(this.nextToken, inventoryListing.nextToken);
    }

    public int hashCode() {
        return Objects.hash(this.inventory, this.nextToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InventoryListing {\n");
        sb.append("    inventory: ").append(this.toIndentedString(this.inventory)).append("\n");
        sb.append("    nextToken: ").append(this.toIndentedString(this.nextToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

