/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.awd.v2024_05_09;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Additional inventory details. This object is only displayed if the details parameter in the request is set to `SHOW`.")
public class InventoryDetails {
    @SerializedName(value="availableDistributableQuantity")
    private Long availableDistributableQuantity = null;
    @SerializedName(value="replenishmentQuantity")
    private Long replenishmentQuantity = null;
    @SerializedName(value="reservedDistributableQuantity")
    private Long reservedDistributableQuantity = null;

    public InventoryDetails availableDistributableQuantity(Long availableDistributableQuantity) {
        this.availableDistributableQuantity = availableDistributableQuantity;
        return this;
    }

    @Schema(description="Quantity that is available for downstream channel replenishment.")
    public Long getAvailableDistributableQuantity() {
        return this.availableDistributableQuantity;
    }

    public void setAvailableDistributableQuantity(Long availableDistributableQuantity) {
        this.availableDistributableQuantity = availableDistributableQuantity;
    }

    public InventoryDetails replenishmentQuantity(Long replenishmentQuantity) {
        this.replenishmentQuantity = replenishmentQuantity;
        return this;
    }

    @Schema(description="Quantity that is in transit from AWD and has not yet been received at FBA.")
    public Long getReplenishmentQuantity() {
        return this.replenishmentQuantity;
    }

    public void setReplenishmentQuantity(Long replenishmentQuantity) {
        this.replenishmentQuantity = replenishmentQuantity;
    }

    public InventoryDetails reservedDistributableQuantity(Long reservedDistributableQuantity) {
        this.reservedDistributableQuantity = reservedDistributableQuantity;
        return this;
    }

    @Schema(description="Quantity that is reserved for a downstream channel replenishment order that is being prepared for shipment.")
    public Long getReservedDistributableQuantity() {
        return this.reservedDistributableQuantity;
    }

    public void setReservedDistributableQuantity(Long reservedDistributableQuantity) {
        this.reservedDistributableQuantity = reservedDistributableQuantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventoryDetails inventoryDetails = (InventoryDetails)o;
        return Objects.equals(this.availableDistributableQuantity, inventoryDetails.availableDistributableQuantity) && Objects.equals(this.replenishmentQuantity, inventoryDetails.replenishmentQuantity) && Objects.equals(this.reservedDistributableQuantity, inventoryDetails.reservedDistributableQuantity);
    }

    public int hashCode() {
        return Objects.hash(this.availableDistributableQuantity, this.replenishmentQuantity, this.reservedDistributableQuantity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InventoryDetails {\n");
        sb.append("    availableDistributableQuantity: ").append(this.toIndentedString(this.availableDistributableQuantity)).append("\n");
        sb.append("    replenishmentQuantity: ").append(this.toIndentedString(this.replenishmentQuantity)).append("\n");
        sb.append("    reservedDistributableQuantity: ").append(this.toIndentedString(this.reservedDistributableQuantity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

