/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.awd.v2024_05_09;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.awd.v2024_05_09.InboundShipmentStatus;

@Schema(description="Summary for an AWD inbound shipment containing the shipment ID, which can be used to retrieve the actual shipment.")
public class InboundShipmentSummary {
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt = null;
    @SerializedName(value="externalReferenceId")
    private String externalReferenceId = null;
    @SerializedName(value="orderId")
    private String orderId = null;
    @SerializedName(value="shipmentId")
    private String shipmentId = null;
    @SerializedName(value="shipmentStatus")
    private InboundShipmentStatus shipmentStatus = null;
    @SerializedName(value="updatedAt")
    private OffsetDateTime updatedAt = null;

    public InboundShipmentSummary createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(description="Timestamp when the shipment was created.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public InboundShipmentSummary externalReferenceId(String externalReferenceId) {
        this.externalReferenceId = externalReferenceId;
        return this;
    }

    @Schema(example="TestReferenceId", description="Optional client-provided reference ID that can be used to correlate this shipment with client resources. For example, to map this shipment to an internal bookkeeping order record.")
    public String getExternalReferenceId() {
        return this.externalReferenceId;
    }

    public void setExternalReferenceId(String externalReferenceId) {
        this.externalReferenceId = externalReferenceId;
    }

    public InboundShipmentSummary orderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    @Schema(required=true, description="The AWD inbound order ID that this inbound shipment belongs to.")
    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public InboundShipmentSummary shipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
        return this;
    }

    @Schema(required=true, description="A unique shipment ID.")
    public String getShipmentId() {
        return this.shipmentId;
    }

    public void setShipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
    }

    public InboundShipmentSummary shipmentStatus(InboundShipmentStatus shipmentStatus) {
        this.shipmentStatus = shipmentStatus;
        return this;
    }

    @Schema(required=true, description="")
    public InboundShipmentStatus getShipmentStatus() {
        return this.shipmentStatus;
    }

    public void setShipmentStatus(InboundShipmentStatus shipmentStatus) {
        this.shipmentStatus = shipmentStatus;
    }

    public InboundShipmentSummary updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Schema(description="Timestamp when the shipment was updated.")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboundShipmentSummary inboundShipmentSummary = (InboundShipmentSummary)o;
        return Objects.equals(this.createdAt, inboundShipmentSummary.createdAt) && Objects.equals(this.externalReferenceId, inboundShipmentSummary.externalReferenceId) && Objects.equals(this.orderId, inboundShipmentSummary.orderId) && Objects.equals(this.shipmentId, inboundShipmentSummary.shipmentId) && Objects.equals((Object)this.shipmentStatus, (Object)inboundShipmentSummary.shipmentStatus) && Objects.equals(this.updatedAt, inboundShipmentSummary.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createdAt, this.externalReferenceId, this.orderId, this.shipmentId, this.shipmentStatus, this.updatedAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InboundShipmentSummary {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    externalReferenceId: ").append(this.toIndentedString(this.externalReferenceId)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    shipmentId: ").append(this.toIndentedString(this.shipmentId)).append("\n");
        sb.append("    shipmentStatus: ").append(this.toIndentedString((Object)this.shipmentStatus)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

